/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.wso2.andes.AMQException;
import org.wso2.andes.dtx.XidImpl;
import org.wso2.andes.framing.DtxEndOkBody;
import org.wso2.andes.framing.amqp_0_91.DtxEndBodyImpl;
import org.wso2.andes.framing.amqp_0_91.MethodRegistry_0_91;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.dtx.NotAssociatedDtxException;
import org.wso2.andes.kernel.dtx.SuspendAndFailDtxException;
import org.wso2.andes.kernel.dtx.UnknownDtxBranchException;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;
import org.wso2.andes.server.txn.DtxNotSelectedException;
import org.wso2.andes.server.txn.TimeoutDtxException;
import org.wso2.andes.transport.DtxXaStatus;

public class DtxEndHandler
implements StateAwareMethodListener<DtxEndBodyImpl> {
    private static DtxEndHandler _instance = new DtxEndHandler();

    public static DtxEndHandler getInstance() {
        return _instance;
    }

    private DtxEndHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, DtxEndBodyImpl body, int channelId) throws AMQException {
        XidImpl xid = new XidImpl(body.getBranchId(), body.getFormat(), body.getGlobalId());
        AMQProtocolSession session = stateManager.getProtocolSession();
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        try {
            DtxEndOkBody dtxEndOkBody;
            try {
                channel.endDtxTransaction(xid, body.getFail(), body.getSuspend());
                MethodRegistry_0_91 methodRegistry = (MethodRegistry_0_91)session.getMethodRegistry();
                dtxEndOkBody = methodRegistry.createDtxEndOkBody(DtxXaStatus.XA_OK.getValue());
            }
            catch (TimeoutDtxException e) {
                MethodRegistry_0_91 methodRegistry = (MethodRegistry_0_91)session.getMethodRegistry();
                dtxEndOkBody = methodRegistry.createDtxEndOkBody(DtxXaStatus.XA_RBTIMEOUT.getValue());
            }
            session.writeFrame(dtxEndOkBody.generateFrame(channelId));
        }
        catch (DtxNotSelectedException e) {
            throw body.getChannelException(AMQConstant.NOT_ALLOWED, "Not a distributed transacted session", e);
        }
        catch (NotAssociatedDtxException e) {
            throw body.getChannelException(AMQConstant.NOT_ALLOWED, "Error ending dtx. Session is not associated with the given xid " + xid, e);
        }
        catch (UnknownDtxBranchException e) {
            throw body.getChannelException(AMQConstant.NOT_ALLOWED, "Error ending dtx. Unknown branch for the given " + xid, e);
        }
        catch (SuspendAndFailDtxException e) {
            throw body.getChannelException(AMQConstant.NOT_ALLOWED, "Error ending dtx. Both suspend and failed are set ", e);
        }
        catch (AndesException e) {
            throw body.getChannelException(AMQConstant.INTERNAL_ERROR, "Internal error in ending dtx.", e);
        }
    }
}

