/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.ConnectionTuneOkBody;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.state.AMQState;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;

public class ConnectionTuneOkMethodHandler
implements StateAwareMethodListener<ConnectionTuneOkBody> {
    private static final Logger _logger = Logger.getLogger(ConnectionTuneOkMethodHandler.class);
    private static ConnectionTuneOkMethodHandler _instance = new ConnectionTuneOkMethodHandler();

    public static ConnectionTuneOkMethodHandler getInstance() {
        return _instance;
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, ConnectionTuneOkBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)body);
        }
        stateManager.changeState(AMQState.CONNECTION_NOT_OPENED);
        session.initHeartbeats(body.getHeartbeat());
        session.setMaxFrameSize(body.getFrameMax());
        long maxChannelNumber = body.getChannelMax();
        session.setMaximumNumberOfChannels(maxChannelNumber == 0L ? 65535L : maxChannelNumber);
    }
}

