/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.apache.log4j.Logger;
import org.wso2.andes.AMQChannelException;
import org.wso2.andes.AMQException;
import org.wso2.andes.amqp.QpidAndesBridge;
import org.wso2.andes.framing.ChannelFlowBody;
import org.wso2.andes.framing.ChannelFlowOkBody;
import org.wso2.andes.framing.MethodRegistry;
import org.wso2.andes.kernel.disruptor.DisruptorEventCallback;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;

public class ChannelFlowHandler
implements StateAwareMethodListener<ChannelFlowBody> {
    private static final Logger logger = Logger.getLogger(ChannelFlowHandler.class);
    private static ChannelFlowHandler _instance = new ChannelFlowHandler();

    public static ChannelFlowHandler getInstance() {
        return _instance;
    }

    private ChannelFlowHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, final ChannelFlowBody body, final int channelId) throws AMQException {
        final AMQProtocolSession session = stateManager.getProtocolSession();
        AMQChannel channel = session.getChannel(channelId);
        if (null == channel) {
            throw body.getChannelNotFoundException(channelId);
        }
        channel.setSuspended(!body.getActive());
        QpidAndesBridge.notifyChannelFlow(channel.getId(), body.getActive(), new DisruptorEventCallback(){

            @Override
            public void execute() {
                MethodRegistry methodRegistry = session.getMethodRegistry();
                ChannelFlowOkBody responseBody = methodRegistry.createChannelFlowOkBody(body.getActive());
                session.writeFrame(responseBody.generateFrame(channelId));
            }

            @Override
            public void onException(Exception exception) {
                logger.error((Object)("Exception occurred while processing channel flow: " + body.getActive()), (Throwable)exception);
                AMQChannelException channelException = body.getChannelException(AMQConstant.INTERNAL_ERROR, exception.getMessage());
                session.writeFrame(channelException.getCloseFrame(channelId));
                try {
                    session.closeChannel(channelId);
                }
                catch (AMQException e) {
                    logger.error((Object)("Couldn't close channel (channel id ) " + channelId), (Throwable)e);
                }
            }
        });
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(" Channel flow: " + body.getActive() + " set for channel: " + channel.getId()));
        }
    }
}

