/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.apache.log4j.Logger;
import org.wso2.andes.AMQChannelException;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.BasicRecoverSyncBody;
import org.wso2.andes.framing.BasicRecoverSyncOkBody;
import org.wso2.andes.framing.ProtocolVersion;
import org.wso2.andes.framing.amqp_0_9.MethodRegistry_0_9;
import org.wso2.andes.framing.amqp_0_91.MethodRegistry_0_91;
import org.wso2.andes.kernel.disruptor.DisruptorEventCallback;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;

public class BasicRecoverSyncMethodHandler
implements StateAwareMethodListener<BasicRecoverSyncBody> {
    private static final Logger _logger = Logger.getLogger(BasicRecoverSyncMethodHandler.class);
    private static final BasicRecoverSyncMethodHandler _instance = new BasicRecoverSyncMethodHandler();

    public static BasicRecoverSyncMethodHandler getInstance() {
        return _instance;
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, final BasicRecoverSyncBody body, final int channelId) throws AMQException {
        final AMQProtocolSession session = stateManager.getProtocolSession();
        _logger.debug((Object)("Recover received on protocol session " + session + " and channel " + channelId));
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        channel.resendRecoveredMessages(new DisruptorEventCallback(){

            @Override
            public void execute() {
                AMQChannel channel = session.getChannel(channelId);
                if (channel == null) {
                    _logger.error((Object)("Channel not found for id " + channelId));
                }
                if (session.getProtocolVersion().equals(ProtocolVersion.v0_9)) {
                    MethodRegistry_0_9 methodRegistry = (MethodRegistry_0_9)session.getMethodRegistry();
                    BasicRecoverSyncOkBody recoverOk = methodRegistry.createBasicRecoverSyncOkBody();
                    session.writeFrame(recoverOk.generateFrame(channelId));
                } else if (session.getProtocolVersion().equals(ProtocolVersion.v0_91)) {
                    MethodRegistry_0_91 methodRegistry = (MethodRegistry_0_91)session.getMethodRegistry();
                    BasicRecoverSyncOkBody recoverOk = methodRegistry.createBasicRecoverSyncOkBody();
                    session.writeFrame(recoverOk.generateFrame(channelId));
                }
            }

            @Override
            public void onException(Exception exception) {
                _logger.error((Object)"Exception occurred when recovering session ", (Throwable)exception);
                AMQChannelException channelException = body.getChannelException(AMQConstant.INTERNAL_ERROR, exception.getMessage());
                session.writeFrame(channelException.getCloseFrame(channelId));
                try {
                    session.closeChannel(channelId);
                }
                catch (AMQException e) {
                    _logger.error((Object)("Couldn't close channel (channel id ) " + channelId), (Throwable)e);
                }
            }
        });
    }
}

