/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.apache.log4j.Logger;
import org.wso2.andes.AMQChannelException;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.BasicRecoverBody;
import org.wso2.andes.framing.BasicRecoverOkBody;
import org.wso2.andes.framing.ProtocolVersion;
import org.wso2.andes.framing.amqp_8_0.MethodRegistry_8_0;
import org.wso2.andes.kernel.disruptor.DisruptorEventCallback;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;

public class BasicRecoverMethodHandler
implements StateAwareMethodListener<BasicRecoverBody> {
    private static final Logger _logger = Logger.getLogger(BasicRecoverMethodHandler.class);
    private static final BasicRecoverMethodHandler _instance = new BasicRecoverMethodHandler();

    public static BasicRecoverMethodHandler getInstance() {
        return _instance;
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, final BasicRecoverBody body, final int channelId) throws AMQException {
        final AMQProtocolSession session = stateManager.getProtocolSession();
        _logger.debug((Object)("Recover received on protocol session " + session + " and channel " + channelId));
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        channel.resendRecoveredMessages(new DisruptorEventCallback(){

            @Override
            public void execute() {
                if (session.getProtocolVersion().equals(ProtocolVersion.v8_0)) {
                    MethodRegistry_8_0 methodRegistry = (MethodRegistry_8_0)session.getMethodRegistry();
                    BasicRecoverOkBody recoverOk = methodRegistry.createBasicRecoverOkBody();
                    session.writeFrame(recoverOk.generateFrame(channelId));
                }
            }

            @Override
            public void onException(Exception exception) {
                _logger.error((Object)"Exception occurred when recovering session ", (Throwable)exception);
                AMQChannelException channelException = body.getChannelException(AMQConstant.INTERNAL_ERROR, exception.getMessage());
                session.writeFrame(channelException.getCloseFrame(channelId));
                try {
                    session.closeChannel(channelId);
                }
                catch (AMQException e) {
                    _logger.error((Object)("Couldn't close channel (channel id ) " + channelId), (Throwable)e);
                }
            }
        });
    }
}

