/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.wso2.andes.AMQException;
import org.wso2.andes.framing.BasicQosBody;
import org.wso2.andes.framing.BasicQosOkBody;
import org.wso2.andes.framing.MethodRegistry;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;

public class BasicQosHandler
implements StateAwareMethodListener<BasicQosBody> {
    private static final BasicQosHandler _instance = new BasicQosHandler();

    public static BasicQosHandler getInstance() {
        return _instance;
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, BasicQosBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        channel.setCredit(body.getPrefetchSize(), body.getPrefetchCount());
        MethodRegistry methodRegistry = session.getMethodRegistry();
        BasicQosOkBody responseBody = methodRegistry.createBasicQosOkBody();
        session.writeFrame(responseBody.generateFrame(channelId));
    }
}

