/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.amqp.AMQPUtils;
import org.wso2.andes.exchange.ExchangeDefaults;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.BasicPublishBody;
import org.wso2.andes.framing.abstraction.MessagePublishInfo;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;
import org.wso2.andes.server.virtualhost.VirtualHost;

public class BasicPublishMethodHandler
implements StateAwareMethodListener<BasicPublishBody> {
    private static final Logger _logger = Logger.getLogger(BasicPublishMethodHandler.class);
    private static final BasicPublishMethodHandler _instance = new BasicPublishMethodHandler();

    public static BasicPublishMethodHandler getInstance() {
        return _instance;
    }

    private BasicPublishMethodHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, BasicPublishBody body, int channelId) throws AMQException {
        VirtualHost vHost;
        Exchange exch;
        AMQShortString exchangeName;
        AMQProtocolSession session = stateManager.getProtocolSession();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Publish received on channel " + channelId));
        }
        if ((exchangeName = body.getExchange()) == null) {
            exchangeName = ExchangeDefaults.DEFAULT_EXCHANGE_NAME;
        }
        if ((exch = (vHost = session.getVirtualHost()).getExchangeRegistry().getExchange(exchangeName)) == null) {
            throw body.getChannelException(AMQConstant.NOT_FOUND, "Unknown exchange name");
        }
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        MessagePublishInfo info = session.getMethodRegistry().getProtocolVersionMethodConverter().convertToInfo(body);
        if (ExchangeDefaults.TOPIC_EXCHANGE_NAME.equals(exchangeName) && AMQPUtils.isWildCardDestination(info.getRoutingKey().toString())) {
            throw body.getChannelException(AMQConstant.INVALID_ROUTING_KEY, "Publishing messages to a wildcard destination is not allowed");
        }
        info.setExchange(exchangeName);
        channel.setPublishFrame(info, exch);
    }
}

