/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.BasicCancelBody;
import org.wso2.andes.framing.BasicCancelOkBody;
import org.wso2.andes.framing.MethodRegistry;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;

public class BasicCancelMethodHandler
implements StateAwareMethodListener<BasicCancelBody> {
    private static final Logger _log = Logger.getLogger(BasicCancelMethodHandler.class);
    private static final BasicCancelMethodHandler _instance = new BasicCancelMethodHandler();

    public static BasicCancelMethodHandler getInstance() {
        return _instance;
    }

    private BasicCancelMethodHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, BasicCancelBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("BasicCancel: for:" + body.getConsumerTag() + " nowait:" + body.getNowait()));
        }
        channel.unsubscribeConsumer(body.getConsumerTag());
        if (!body.getNowait()) {
            MethodRegistry methodRegistry = session.getMethodRegistry();
            BasicCancelOkBody cancelOkBody = methodRegistry.createBasicCancelOkBody(body.getConsumerTag());
            session.writeFrame(cancelOkBody.generateFrame(channelId));
        }
    }
}

