/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AccessRequestBody;
import org.wso2.andes.framing.AccessRequestOkBody;
import org.wso2.andes.framing.MethodRegistry;
import org.wso2.andes.framing.amqp_0_9.MethodRegistry_0_9;
import org.wso2.andes.framing.amqp_8_0.MethodRegistry_8_0;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;

public class AccessRequestHandler
implements StateAwareMethodListener<AccessRequestBody> {
    private static final AccessRequestHandler _instance = new AccessRequestHandler();

    public static AccessRequestHandler getInstance() {
        return _instance;
    }

    private AccessRequestHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, AccessRequestBody body, int channelId) throws AMQException {
        AccessRequestOkBody response;
        AMQProtocolSession session = stateManager.getProtocolSession();
        MethodRegistry methodRegistry = session.getMethodRegistry();
        if (methodRegistry instanceof MethodRegistry_0_9) {
            response = ((MethodRegistry_0_9)methodRegistry).createAccessRequestOkBody(0);
        } else if (methodRegistry instanceof MethodRegistry_8_0) {
            response = ((MethodRegistry_8_0)methodRegistry).createAccessRequestOkBody(0);
        } else {
            throw new AMQException(AMQConstant.COMMAND_INVALID, "AccessRequest not present in AMQP versions other than 0-8, 0-9");
        }
        session.writeFrame(response.generateFrame(channelId));
    }
}

