/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.flow;

import java.util.concurrent.atomic.AtomicLong;
import org.wso2.andes.server.flow.AbstractFlowCreditManager;
import org.wso2.andes.server.flow.FlowCreditManager;
import org.wso2.andes.server.message.ServerMessage;

public class MessageOnlyCreditManager
extends AbstractFlowCreditManager
implements FlowCreditManager {
    private final AtomicLong _messageCredit;

    public MessageOnlyCreditManager(long initialCredit) {
        this._messageCredit = new AtomicLong(initialCredit);
    }

    @Override
    public long getMessageCredit() {
        return this._messageCredit.get();
    }

    @Override
    public long getBytesCredit() {
        return -1L;
    }

    @Override
    public void restoreCredit(long messageCredit, long bytesCredit) {
        this._messageCredit.addAndGet(messageCredit);
        this.setSuspended(false);
    }

    public void removeAllCredit() {
        this.setSuspended(true);
        this._messageCredit.set(0L);
    }

    @Override
    public boolean hasCredit() {
        return this._messageCredit.get() > 0L;
    }

    @Override
    public boolean useCreditForMessage(ServerMessage msg) {
        if (this.hasCredit()) {
            if (this._messageCredit.addAndGet(-1L) >= 0L) {
                this.setSuspended(false);
                return true;
            }
            this._messageCredit.addAndGet(1L);
            this.setSuspended(true);
            return false;
        }
        this.setSuspended(true);
        return false;
    }
}

