/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.flow;

import org.wso2.andes.server.flow.AbstractFlowCreditManager;
import org.wso2.andes.server.flow.FlowCreditManager;
import org.wso2.andes.server.message.ServerMessage;

public class MessageAndBytesCreditManager
extends AbstractFlowCreditManager
implements FlowCreditManager {
    private long _messageCredit;
    private long _bytesCredit;

    public MessageAndBytesCreditManager(long messageCredit, long bytesCredit) {
        this._messageCredit = messageCredit;
        this._bytesCredit = bytesCredit;
    }

    @Override
    public synchronized long getMessageCredit() {
        return this._messageCredit;
    }

    @Override
    public synchronized long getBytesCredit() {
        return this._bytesCredit;
    }

    @Override
    public synchronized void restoreCredit(long messageCredit, long bytesCredit) {
        this._messageCredit += messageCredit;
        this._bytesCredit += bytesCredit;
        this.setSuspended(this.hasCredit());
    }

    public synchronized void removeAllCredit() {
        this._messageCredit = 0L;
        this._bytesCredit = 0L;
        this.setSuspended(true);
    }

    @Override
    public synchronized boolean hasCredit() {
        return this._messageCredit > 0L && this._bytesCredit > 0L;
    }

    @Override
    public synchronized boolean useCreditForMessage(ServerMessage msg) {
        if (this._messageCredit == 0L) {
            this.setSuspended(true);
            return false;
        }
        long msgSize = msg.getSize();
        if (msgSize > this._bytesCredit) {
            this.setSuspended(true);
            return false;
        }
        --this._messageCredit;
        this._bytesCredit -= msgSize;
        this.setSuspended(false);
        return true;
    }

    public synchronized void setBytesCredit(long bytesCredit) {
        this._bytesCredit = bytesCredit;
    }
}

