/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.flow;

import java.util.concurrent.atomic.AtomicLong;
import org.wso2.andes.server.flow.AbstractFlowCreditManager;
import org.wso2.andes.server.message.ServerMessage;

public class BytesOnlyCreditManager
extends AbstractFlowCreditManager {
    private final AtomicLong _bytesCredit;

    public BytesOnlyCreditManager(long initialCredit) {
        this._bytesCredit = new AtomicLong(initialCredit);
    }

    @Override
    public long getMessageCredit() {
        return -1L;
    }

    @Override
    public long getBytesCredit() {
        return this._bytesCredit.get();
    }

    @Override
    public void restoreCredit(long messageCredit, long bytesCredit) {
        this._bytesCredit.addAndGet(bytesCredit);
        this.setSuspended(false);
    }

    public void removeAllCredit() {
        this._bytesCredit.set(0L);
    }

    @Override
    public boolean hasCredit() {
        return this._bytesCredit.get() > 0L;
    }

    @Override
    public boolean useCreditForMessage(ServerMessage msg) {
        long msgSize = msg.getSize();
        if (this.hasCredit()) {
            if (this._bytesCredit.addAndGet(-msgSize) >= 0L) {
                return true;
            }
            this._bytesCredit.addAndGet(msgSize);
            this.setSuspended(true);
            return false;
        }
        return false;
    }

    public void setBytesCredit(long bytesCredit) {
        this._bytesCredit.set(bytesCredit);
    }
}

