/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.exchange.topic;

import java.util.ArrayList;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.AMQShortStringTokenizer;

public class TopicNormalizer {
    private static final byte TOPIC_SEPARATOR = 46;
    private static final byte HASH_BYTE = 35;
    private static final byte STAR_BYTE = 42;
    private static final AMQShortString TOPIC_SEPARATOR_AS_SHORTSTRING = new AMQShortString(".");
    private static final AMQShortString AMQP_STAR_TOKEN = new AMQShortString("*");
    private static final AMQShortString AMQP_HASH_TOKEN = new AMQShortString("#");

    public static AMQShortString normalize(AMQShortString routingKey) {
        if (routingKey == null) {
            return AMQShortString.EMPTY_STRING;
        }
        if (!routingKey.contains((byte)35) && !routingKey.contains((byte)42)) {
            return routingKey;
        }
        AMQShortStringTokenizer routingTokens = routingKey.tokenize((byte)46);
        ArrayList<AMQShortString> subscriptionList = new ArrayList<AMQShortString>();
        while (routingTokens.hasMoreTokens()) {
            subscriptionList.add(routingTokens.nextToken());
        }
        int size = subscriptionList.size();
        for (int index = 0; index < size; ++index) {
            if (index + 1 >= size || !((AMQShortString)subscriptionList.get(index)).equals(AMQP_HASH_TOKEN)) continue;
            if (((AMQShortString)subscriptionList.get(index + 1)).equals(AMQP_HASH_TOKEN)) {
                subscriptionList.remove(index);
                --size;
                --index;
            }
            if (!((AMQShortString)subscriptionList.get(index + 1)).equals(AMQP_STAR_TOKEN)) continue;
            subscriptionList.add(index + 1, (AMQShortString)subscriptionList.remove(index));
        }
        AMQShortString normalizedString = AMQShortString.join(subscriptionList, TOPIC_SEPARATOR_AS_SHORTSTRING);
        return normalizedString;
    }
}

