/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.exchange;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.wso2.andes.management.common.mbeans.annotations.MBeanConstructor;
import org.wso2.andes.management.common.mbeans.annotations.MBeanDescription;
import org.wso2.andes.server.binding.Binding;
import org.wso2.andes.server.exchange.AbstractExchangeMBean;
import org.wso2.andes.server.exchange.TopicExchange;

@MBeanDescription(value="Management Bean for Topic Exchange")
final class TopicExchangeMBean
extends AbstractExchangeMBean<TopicExchange> {
    private TopicExchange _topicExchange;

    @MBeanConstructor(value="Creates an MBean for AMQ topic exchange")
    public TopicExchangeMBean(TopicExchange topicExchange) throws JMException {
        super(topicExchange);
        this.init();
    }

    @Override
    public TabularData bindings() throws OpenDataException {
        TabularDataSupport bindingList = new TabularDataSupport(this._bindinglistDataType);
        HashMap<String, ArrayList<String>> bindingData = new HashMap<String, ArrayList<String>>();
        for (Binding binding : ((TopicExchange)this.getExchange()).getBindings()) {
            String key = binding.getBindingKey();
            ArrayList<String> queueNames = (ArrayList<String>)bindingData.get(key);
            if (queueNames == null) {
                queueNames = new ArrayList<String>();
                bindingData.put(key, queueNames);
            }
            queueNames.add(binding.getQueue().getNameShortString().toString());
        }
        for (Map.Entry entry : bindingData.entrySet()) {
            Object[] bindingItemValues = new Object[]{entry.getKey(), ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()])};
            CompositeDataSupport bindingCompositeData = new CompositeDataSupport(this._bindingDataType, COMPOSITE_ITEM_NAMES.toArray(new String[COMPOSITE_ITEM_NAMES.size()]), bindingItemValues);
            bindingList.put(bindingCompositeData);
        }
        return bindingList;
    }
}

