/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.exchange;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.JMException;
import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.AMQInvalidArgumentException;
import org.wso2.andes.common.AMQPFilterTypes;
import org.wso2.andes.exchange.ExchangeDefaults;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.server.binding.Binding;
import org.wso2.andes.server.exchange.AbstractExchange;
import org.wso2.andes.server.exchange.AbstractExchangeMBean;
import org.wso2.andes.server.exchange.ExchangeType;
import org.wso2.andes.server.exchange.TopicExchangeMBean;
import org.wso2.andes.server.exchange.topic.TopicExchangeResult;
import org.wso2.andes.server.exchange.topic.TopicMatcherResult;
import org.wso2.andes.server.exchange.topic.TopicNormalizer;
import org.wso2.andes.server.exchange.topic.TopicParser;
import org.wso2.andes.server.filter.JMSSelectorFilter;
import org.wso2.andes.server.message.InboundMessage;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.BaseQueue;
import org.wso2.andes.server.virtualhost.VirtualHost;

public class TopicExchange
extends AbstractExchange {
    public static final ExchangeType<TopicExchange> TYPE = new ExchangeType<TopicExchange>(){

        @Override
        public AMQShortString getName() {
            return ExchangeDefaults.TOPIC_EXCHANGE_CLASS;
        }

        @Override
        public Class<TopicExchange> getExchangeClass() {
            return TopicExchange.class;
        }

        @Override
        public TopicExchange newInstance(VirtualHost host, AMQShortString name, boolean durable, int ticket, boolean autoDelete) throws AMQException {
            TopicExchange exch = new TopicExchange();
            exch.initialise(host, name, durable, ticket, autoDelete);
            return exch;
        }

        @Override
        public AMQShortString getDefaultExchangeName() {
            return ExchangeDefaults.TOPIC_EXCHANGE_NAME;
        }
    };
    private static final Logger _logger = Logger.getLogger(TopicExchange.class);
    private final TopicParser _parser = new TopicParser();
    private final Map<AMQShortString, TopicExchangeResult> _topicExchangeResults = new ConcurrentHashMap<AMQShortString, TopicExchangeResult>();
    private final Map<Binding, FieldTable> _bindings = new HashMap<Binding, FieldTable>();
    private final Map<String, WeakReference<JMSSelectorFilter>> _selectorCache = new WeakHashMap<String, WeakReference<JMSSelectorFilter>>();

    public TopicExchange() {
        super(TYPE);
    }

    protected synchronized void registerQueue(Binding binding) throws AMQInvalidArgumentException {
        AMQShortString rKey = new AMQShortString(binding.getBindingKey());
        AMQQueue queue = binding.getQueue();
        FieldTable args = FieldTable.convertToFieldTable(binding.getArguments());
        assert (queue != null);
        assert (rKey != null);
        _logger.debug((Object)("Registering queue " + queue.getNameShortString() + " with routing key " + rKey));
        AMQShortString routingKey = TopicNormalizer.normalize(rKey);
        if (this._bindings.containsKey(binding)) {
            FieldTable oldArgs = this._bindings.get(binding);
            TopicExchangeResult result = this._topicExchangeResults.get(routingKey);
            if (TopicExchange.argumentsContainSelector(args)) {
                if (TopicExchange.argumentsContainSelector(oldArgs)) {
                    result.replaceQueueFilter(queue, this.createSelectorFilter(oldArgs), this.createSelectorFilter(args));
                } else {
                    result.addFilteredQueue(queue, this.createSelectorFilter(args));
                    result.removeUnfilteredQueue(queue);
                }
            } else if (TopicExchange.argumentsContainSelector(oldArgs)) {
                result.addUnfilteredQueue(queue);
                result.removeFilteredQueue(queue, this.createSelectorFilter(oldArgs));
            } else {
                return;
            }
            result.addBinding(binding);
        } else {
            TopicExchangeResult result = this._topicExchangeResults.get(routingKey);
            if (result == null) {
                result = new TopicExchangeResult();
                if (TopicExchange.argumentsContainSelector(args)) {
                    result.addFilteredQueue(queue, this.createSelectorFilter(args));
                } else {
                    result.addUnfilteredQueue(queue);
                }
                this._parser.addBinding(routingKey, result);
                this._topicExchangeResults.put(routingKey, result);
            } else if (TopicExchange.argumentsContainSelector(args)) {
                result.addFilteredQueue(queue, this.createSelectorFilter(args));
            } else {
                result.addUnfilteredQueue(queue);
            }
            result.addBinding(binding);
            this._bindings.put(binding, args);
        }
    }

    private JMSSelectorFilter createSelectorFilter(FieldTable args) throws AMQInvalidArgumentException {
        String selectorString = args.getString(AMQPFilterTypes.JMS_SELECTOR.getValue());
        WeakReference<JMSSelectorFilter> selectorRef = this._selectorCache.get(selectorString);
        JMSSelectorFilter selector = null;
        if (selectorRef == null || (selector = (JMSSelectorFilter)selectorRef.get()) == null) {
            selector = new JMSSelectorFilter(selectorString);
            this._selectorCache.put(selectorString, new WeakReference<JMSSelectorFilter>(selector));
        }
        return selector;
    }

    private static boolean argumentsContainSelector(FieldTable args) {
        return args != null && args.containsKey(AMQPFilterTypes.JMS_SELECTOR.getValue()) && args.getString(AMQPFilterTypes.JMS_SELECTOR.getValue()).trim().length() != 0;
    }

    public ArrayList<BaseQueue> doRoute(InboundMessage payload) {
        AMQShortString routingKey = payload.getRoutingKey() == null ? AMQShortString.EMPTY_STRING : new AMQShortString(payload.getRoutingKey());
        ArrayList<BaseQueue> queues = new ArrayList<BaseQueue>();
        queues.addAll(this.getMatchedQueues(payload, routingKey));
        if ((queues == null || queues.isEmpty()) && !AndesContext.getInstance().isClusteringEnabled()) {
            _logger.info((Object)("Message routing key: " + payload.getRoutingKey() + " No routes."));
        }
        return queues;
    }

    @Override
    public boolean isBound(AMQShortString routingKey, FieldTable arguments, AMQQueue queue) {
        Binding binding = new Binding(null, routingKey.toString(), queue, this, FieldTable.convertToMap(arguments));
        if (arguments == null) {
            return this._bindings.containsKey(binding);
        }
        FieldTable o = this._bindings.get(binding);
        if (o != null) {
            return o.equals(arguments);
        }
        return false;
    }

    @Override
    public boolean isBound(AMQShortString routingKey, AMQQueue queue) {
        return this.isBound(routingKey, null, queue);
    }

    @Override
    public boolean isBound(AMQShortString routingKey) {
        for (Binding b : this._bindings.keySet()) {
            if (!b.getBindingKey().equals(routingKey.toString())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBound(AMQQueue queue) {
        for (Binding b : this._bindings.keySet()) {
            if (!b.getQueue().equals(queue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasBindings() {
        return !this._bindings.isEmpty();
    }

    private boolean deregisterQueue(Binding binding) {
        if (this._bindings.containsKey(binding)) {
            FieldTable bindingArgs = this._bindings.remove(binding);
            AMQShortString bindingKey = TopicNormalizer.normalize(new AMQShortString(binding.getBindingKey()));
            TopicExchangeResult result = this._topicExchangeResults.get(bindingKey);
            result.removeBinding(binding);
            if (TopicExchange.argumentsContainSelector(bindingArgs)) {
                try {
                    result.removeFilteredQueue(binding.getQueue(), this.createSelectorFilter(bindingArgs));
                }
                catch (AMQInvalidArgumentException e) {
                    return false;
                }
            } else {
                result.removeUnfilteredQueue(binding.getQueue());
            }
            return true;
        }
        return false;
    }

    @Override
    protected AbstractExchangeMBean createMBean() throws JMException {
        return new TopicExchangeMBean(this);
    }

    @Override
    public Logger getLogger() {
        return _logger;
    }

    private Collection<AMQQueue> getMatchedQueues(InboundMessage message, AMQShortString routingKey) {
        Collection<TopicMatcherResult> results = this._parser.parse(routingKey);
        if (results.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        Collection<AMQQueue> queues = results.size() == 1 ? null : new HashSet<AMQQueue>();
        for (TopicMatcherResult result : results) {
            TopicExchangeResult res = (TopicExchangeResult)result;
            for (Binding b : res.getBindings()) {
                b.incrementMatches();
            }
            queues = res.processMessage(message, queues);
        }
        return queues;
    }

    @Override
    protected void onBind(Binding binding) {
        try {
            this.registerQueue(binding);
        }
        catch (AMQInvalidArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void onUnbind(Binding binding) {
        this.deregisterQueue(binding);
    }
}

