/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.exchange;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.JMException;
import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.exchange.ExchangeDefaults;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.server.binding.Binding;
import org.wso2.andes.server.exchange.AbstractExchange;
import org.wso2.andes.server.exchange.AbstractExchangeMBean;
import org.wso2.andes.server.exchange.ExchangeType;
import org.wso2.andes.server.exchange.FanoutExchangeMBean;
import org.wso2.andes.server.message.InboundMessage;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.BaseQueue;
import org.wso2.andes.server.virtualhost.VirtualHost;

public class FanoutExchange
extends AbstractExchange {
    private static final Logger _logger = Logger.getLogger(FanoutExchange.class);
    private static final Integer ONE = 1;
    private final ConcurrentHashMap<AMQQueue, Integer> _queues = new ConcurrentHashMap();
    public static final ExchangeType<FanoutExchange> TYPE = new ExchangeType<FanoutExchange>(){

        @Override
        public AMQShortString getName() {
            return ExchangeDefaults.FANOUT_EXCHANGE_CLASS;
        }

        @Override
        public Class<FanoutExchange> getExchangeClass() {
            return FanoutExchange.class;
        }

        @Override
        public FanoutExchange newInstance(VirtualHost host, AMQShortString name, boolean durable, int ticket, boolean autoDelete) throws AMQException {
            FanoutExchange exch = new FanoutExchange();
            exch.initialise(host, name, durable, ticket, autoDelete);
            return exch;
        }

        @Override
        public AMQShortString getDefaultExchangeName() {
            return ExchangeDefaults.FANOUT_EXCHANGE_NAME;
        }
    };

    @Override
    protected AbstractExchangeMBean createMBean() throws JMException {
        return new FanoutExchangeMBean(this);
    }

    @Override
    public Logger getLogger() {
        return _logger;
    }

    public FanoutExchange() {
        super(TYPE);
    }

    public ArrayList<BaseQueue> doRoute(InboundMessage payload) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Publishing message to queue " + this._queues));
        }
        for (Binding b : this.getBindings()) {
            b.incrementMatches();
        }
        return new ArrayList<BaseQueue>(this._queues.keySet());
    }

    @Override
    public boolean isBound(AMQShortString routingKey, FieldTable arguments, AMQQueue queue) {
        return this.isBound(routingKey, queue);
    }

    @Override
    public boolean isBound(AMQShortString routingKey, AMQQueue queue) {
        return this._queues.contains(queue);
    }

    @Override
    public boolean isBound(AMQShortString routingKey) {
        return this._queues != null && !this._queues.isEmpty();
    }

    @Override
    public boolean isBound(AMQQueue queue) {
        return this._queues.contains(queue);
    }

    @Override
    public boolean hasBindings() {
        return !this._queues.isEmpty();
    }

    @Override
    protected void onBind(Binding binding) {
        AMQQueue queue = binding.getQueue();
        assert (queue != null);
        Integer oldVal = this._queues.putIfAbsent(queue, ONE);
        if (oldVal != null) {
            Integer newVal = oldVal + 1;
            while (!(this._queues.replace(queue, oldVal, newVal) || (oldVal = this._queues.get(queue)) == null && (oldVal = this._queues.putIfAbsent(queue, ONE)) == null)) {
                newVal = oldVal + 1;
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Binding queue " + queue + " with routing key " + new AMQShortString(binding.getBindingKey()) + " to exchange " + this));
        }
    }

    @Override
    protected void onUnbind(Binding binding) {
        AMQQueue queue = binding.getQueue();
        Integer oldValue = this._queues.get(queue);
        boolean done = false;
        while (!done && oldValue != null) {
            while (!done && oldValue != null && oldValue == 1) {
                if (!this._queues.remove(queue, oldValue)) {
                    oldValue = this._queues.get(queue);
                    continue;
                }
                done = true;
            }
            while (!done && oldValue != null && oldValue != 1) {
                Integer newValue = oldValue - 1;
                if (!this._queues.replace(queue, oldValue, newValue)) {
                    oldValue = this._queues.get(queue);
                    continue;
                }
                done = true;
            }
        }
    }
}

