/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.exchange;

import org.wso2.andes.AMQException;
import org.wso2.andes.amqp.QpidAndesBridge;
import org.wso2.andes.exchange.ExchangeDefaults;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.exchange.ExchangeFactory;
import org.wso2.andes.server.exchange.ExchangeRegistry;
import org.wso2.andes.server.exchange.ExchangeType;
import org.wso2.andes.server.store.DurableConfigurationStore;

public class ExchangeInitialiser {
    public void initialise(ExchangeFactory factory, ExchangeRegistry registry, DurableConfigurationStore store) throws AMQException {
        for (ExchangeType<? extends Exchange> type : factory.getRegisteredTypes()) {
            this.define(registry, factory, type.getDefaultExchangeName(), type.getName(), store);
        }
        this.define(registry, factory, ExchangeDefaults.DEFAULT_EXCHANGE_NAME, ExchangeDefaults.DIRECT_EXCHANGE_CLASS, store);
        registry.setDefaultExchange(registry.getExchange(ExchangeDefaults.DEFAULT_EXCHANGE_NAME));
    }

    private void define(ExchangeRegistry r, ExchangeFactory f, AMQShortString name, AMQShortString type, DurableConfigurationStore store) throws AMQException {
        if (r.getExchange(name) == null) {
            Exchange exchange = f.createExchange(name, type, true, false, 0);
            r.registerExchange(exchange);
            if (exchange.isDurable()) {
                store.createExchange(exchange);
                QpidAndesBridge.createExchange(exchange);
            }
        }
    }
}

