/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.exchange;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.wso2.andes.management.common.mbeans.annotations.MBeanConstructor;
import org.wso2.andes.management.common.mbeans.annotations.MBeanDescription;
import org.wso2.andes.server.binding.Binding;
import org.wso2.andes.server.exchange.AbstractExchangeMBean;
import org.wso2.andes.server.exchange.DirectExchange;

@MBeanDescription(value="Management Bean for Direct Exchange")
final class DirectExchangeMBean
extends AbstractExchangeMBean<DirectExchange> {
    @MBeanConstructor(value="Creates an MBean for AMQ direct exchange")
    public DirectExchangeMBean(DirectExchange exchange) throws JMException {
        super(exchange);
        this.init();
    }

    @Override
    public TabularData bindings() throws OpenDataException {
        TabularDataSupport bindingList = new TabularDataSupport(this._bindinglistDataType);
        HashMap<String, ArrayList<String>> bindingMap = new HashMap<String, ArrayList<String>>();
        for (Binding binding : ((DirectExchange)this.getExchange()).getBindings()) {
            String key = binding.getBindingKey();
            ArrayList<String> queueList = (ArrayList<String>)bindingMap.get(key);
            if (queueList == null) {
                queueList = new ArrayList<String>();
                bindingMap.put(key, queueList);
            }
            queueList.add(binding.getQueue().getNameShortString().toString());
        }
        for (Map.Entry entry : bindingMap.entrySet()) {
            Object[] bindingItemValues = new Object[]{entry.getKey(), ((List)entry.getValue()).toArray(new String[0])};
            CompositeDataSupport bindingData = new CompositeDataSupport(this._bindingDataType, COMPOSITE_ITEM_NAMES.toArray(new String[COMPOSITE_ITEM_NAMES.size()]), bindingItemValues);
            bindingList.put(bindingData);
        }
        return bindingList;
    }
}

