/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.exchange;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.management.JMException;
import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.exchange.ExchangeDefaults;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.server.binding.Binding;
import org.wso2.andes.server.exchange.AbstractExchange;
import org.wso2.andes.server.exchange.AbstractExchangeMBean;
import org.wso2.andes.server.exchange.DirectExchangeMBean;
import org.wso2.andes.server.exchange.ExchangeType;
import org.wso2.andes.server.message.InboundMessage;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.BaseQueue;
import org.wso2.andes.server.virtualhost.VirtualHost;

public class DirectExchange
extends AbstractExchange {
    private static final Logger _logger = Logger.getLogger(DirectExchange.class);
    private final ConcurrentHashMap<String, CopyOnWriteArraySet<Binding>> _bindingsByKey = new ConcurrentHashMap();
    public static final ExchangeType<DirectExchange> TYPE = new ExchangeType<DirectExchange>(){

        @Override
        public AMQShortString getName() {
            return ExchangeDefaults.DIRECT_EXCHANGE_CLASS;
        }

        @Override
        public Class<DirectExchange> getExchangeClass() {
            return DirectExchange.class;
        }

        @Override
        public DirectExchange newInstance(VirtualHost host, AMQShortString name, boolean durable, int ticket, boolean autoDelete) throws AMQException {
            DirectExchange exch = new DirectExchange();
            exch.initialise(host, name, durable, ticket, autoDelete);
            return exch;
        }

        @Override
        public AMQShortString getDefaultExchangeName() {
            return ExchangeDefaults.DIRECT_EXCHANGE_NAME;
        }
    };

    public DirectExchange() {
        super(TYPE);
    }

    @Override
    protected AbstractExchangeMBean createMBean() throws JMException {
        return new DirectExchangeMBean(this);
    }

    @Override
    public Logger getLogger() {
        return _logger;
    }

    @Override
    public ArrayList<? extends BaseQueue> doRoute(InboundMessage payload) {
        String routingKey = payload.getRoutingKey();
        CopyOnWriteArraySet<Binding> bindings = this._bindingsByKey.get(routingKey == null ? "" : routingKey);
        if (bindings != null) {
            ArrayList<AMQQueue> queues = new ArrayList<AMQQueue>(bindings.size());
            for (Binding binding : bindings) {
                queues.add(binding.getQueue());
                binding.incrementMatches();
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Publishing message to queue " + queues));
            }
            return queues;
        }
        return new ArrayList(0);
    }

    @Override
    public boolean isBound(AMQShortString routingKey, FieldTable arguments, AMQQueue queue) {
        return this.isBound(routingKey, queue);
    }

    @Override
    public boolean isBound(AMQShortString routingKey, AMQQueue queue) {
        String bindingKey = routingKey == null ? "" : routingKey.toString();
        CopyOnWriteArraySet<Binding> bindings = this._bindingsByKey.get(bindingKey);
        if (bindings != null) {
            for (Binding binding : bindings) {
                if (!binding.getQueue().equals(queue)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isBound(AMQShortString routingKey) {
        String bindingKey = routingKey == null ? "" : routingKey.toString();
        CopyOnWriteArraySet<Binding> bindings = this._bindingsByKey.get(bindingKey);
        return bindings != null && !bindings.isEmpty();
    }

    @Override
    public boolean isBound(AMQQueue queue) {
        for (CopyOnWriteArraySet<Binding> bindings : this._bindingsByKey.values()) {
            for (Binding binding : bindings) {
                if (!binding.getQueue().equals(queue)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasBindings() {
        return !this.getBindings().isEmpty();
    }

    @Override
    protected void onBind(Binding binding) {
        CopyOnWriteArraySet<Binding> newBindings;
        String bindingKey = binding.getBindingKey();
        AMQQueue queue = binding.getQueue();
        AMQShortString routingKey = AMQShortString.valueOf(bindingKey);
        assert (queue != null);
        assert (routingKey != null);
        CopyOnWriteArraySet<Binding> bindings = this._bindingsByKey.get(bindingKey);
        if (bindings == null && (newBindings = this._bindingsByKey.putIfAbsent(bindingKey, bindings = new CopyOnWriteArraySet())) != null) {
            bindings = newBindings;
        }
        bindings.add(binding);
    }

    @Override
    protected void onUnbind(Binding binding) {
        assert (binding != null);
        CopyOnWriteArraySet<Binding> bindings = this._bindingsByKey.get(binding.getBindingKey());
        if (bindings != null) {
            bindings.remove(binding);
        }
    }
}

