/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.exchange;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.AMQSecurityException;
import org.wso2.andes.amqp.QpidAndesBridge;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.exchange.ExchangeInitialiser;
import org.wso2.andes.server.exchange.ExchangeRegistry;
import org.wso2.andes.server.queue.IncomingMessage;
import org.wso2.andes.server.store.DurableConfigurationStore;
import org.wso2.andes.server.virtualhost.VirtualHost;

public class DefaultExchangeRegistry
implements ExchangeRegistry {
    private static final Logger _log = Logger.getLogger(DefaultExchangeRegistry.class);
    private ConcurrentMap<AMQShortString, Exchange> _exchangeMap = new ConcurrentHashMap<AMQShortString, Exchange>();
    private ConcurrentMap<String, Exchange> _exchangeMapStr = new ConcurrentHashMap<String, Exchange>();
    private Exchange _defaultExchange;
    private VirtualHost _host;

    public DefaultExchangeRegistry(VirtualHost host) {
        this._host = host;
    }

    @Override
    public void initialise() throws AMQException {
        new ExchangeInitialiser().initialise(this._host.getExchangeFactory(), this, this.getDurableConfigurationStore());
    }

    public DurableConfigurationStore getDurableConfigurationStore() {
        return this._host.getDurableConfigurationStore();
    }

    @Override
    public void registerExchange(Exchange exchange) throws AMQException {
        this._exchangeMap.put(exchange.getNameShortString(), exchange);
        this._exchangeMapStr.put(exchange.getNameShortString().toString(), exchange);
    }

    @Override
    public void setDefaultExchange(Exchange exchange) {
        this._defaultExchange = exchange;
    }

    @Override
    public Exchange getDefaultExchange() {
        return this._defaultExchange;
    }

    @Override
    public Collection<AMQShortString> getExchangeNames() {
        return this._exchangeMap.keySet();
    }

    @Override
    public void unregisterExchange(AMQShortString name, boolean inUse) throws AMQException {
        if (!this._host.getSecurityManager().authoriseDelete((Exchange)this._exchangeMap.get(name))) {
            throw new AMQSecurityException();
        }
        Exchange e = (Exchange)this._exchangeMap.remove(name);
        this._exchangeMapStr.remove(name.toString());
        if (e != null) {
            if (e.isDurable()) {
                this.getDurableConfigurationStore().removeExchange(e);
                QpidAndesBridge.deleteExchange(e);
            }
        } else {
            throw new AMQException("Unknown exchange " + name);
        }
        e.close();
    }

    @Override
    public void unregisterExchange(String name, boolean inUse) throws AMQException {
        this.unregisterExchange(new AMQShortString(name), inUse);
    }

    @Override
    public Exchange getExchange(AMQShortString name) {
        if (name == null || name.length() == 0) {
            return this.getDefaultExchange();
        }
        return (Exchange)this._exchangeMap.get(name);
    }

    @Override
    public Exchange getExchange(String name) {
        if (name == null || name.length() == 0) {
            return this.getDefaultExchange();
        }
        return (Exchange)this._exchangeMapStr.get(name);
    }

    @Override
    public void routeContent(IncomingMessage payload) throws AMQException {
        AMQShortString exchange = payload.getExchange();
        Exchange exch = this.getExchange(exchange);
        if (exch == null) {
            throw new AMQException("Exchange '" + exchange + "' does not exist");
        }
        payload.enqueue(exch.route(payload));
    }
}

