/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster.error.detection;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.HazelcastLifecycleListener;
import org.wso2.andes.server.cluster.error.detection.NetworkPartitionDetector;
import org.wso2.andes.server.cluster.error.detection.NetworkPartitionListener;

public class HazelcastBasedNetworkPartitionDetector
implements NetworkPartitionDetector,
MembershipListener {
    private Log log = LogFactory.getLog(HazelcastBasedNetworkPartitionDetector.class);
    private SortedMap<Integer, NetworkPartitionListener> networkPartitionListeners = Collections.synchronizedSortedMap(new TreeMap());
    private int minimumClusterSize = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.RECOVERY_NETWORK_PARTITIONS_MINIMUM_CLUSTER_SIZE);
    private HazelcastInstance hazelcastInstance;
    private boolean isNetworkPartitioned;
    private String membershipListener;
    private String lifecycleListener;

    public HazelcastBasedNetworkPartitionDetector(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
        this.isNetworkPartitioned = false;
    }

    private synchronized void detectNetworkPartitions(PartitionEventType eventType, int clusterSize) {
        int currentClusterSize = -1;
        if (eventType != PartitionEventType.CLUSTERING_OUTAGE) {
            currentClusterSize = clusterSize;
        }
        this.log.info((Object)("Network partition event received: " + (Object)((Object)eventType) + " current cluster size: " + currentClusterSize));
        if (eventType == PartitionEventType.START_UP) {
            if (currentClusterSize < this.minimumClusterSize) {
                this.isNetworkPartitioned = true;
                this.minimumNodeCountNotFulfilled(currentClusterSize);
            } else {
                this.minimumNodeCountFulfilled(currentClusterSize);
            }
        } else if (eventType == PartitionEventType.CLUSTERING_OUTAGE) {
            this.log.fatal((Object)"Cluster outage detected.");
            this.clusteringOutage();
        } else if (!this.isNetworkPartitioned && currentClusterSize < this.minimumClusterSize) {
            this.log.info((Object)("Current cluster size has reduced below minimum cluster size, current cluster size: " + currentClusterSize));
            this.isNetworkPartitioned = true;
            this.minimumNodeCountNotFulfilled(currentClusterSize);
        } else if (this.isNetworkPartitioned && currentClusterSize >= this.minimumClusterSize) {
            this.log.info((Object)("Current cluster size satisfies minimum required. current cluster size: " + currentClusterSize));
            this.isNetworkPartitioned = false;
            this.minimumNodeCountFulfilled(currentClusterSize);
        }
    }

    @Override
    public synchronized void addNetworkPartitionListener(int priority, NetworkPartitionListener listener) {
        NetworkPartitionListener previous = this.networkPartitionListeners.put(priority, listener);
        if (null != previous) {
            throw new IllegalArgumentException("Priority value is already used. Please use a different priority level for " + listener);
        }
        if (this.isNetworkPartitioned) {
            this.log.warn((Object)("network partition listener added while in cluster nodes doesn't meet minimum node count: " + this.minimumClusterSize + " listener : " + listener.toString()));
            listener.minimumNodeCountNotFulfilled(-1);
        }
    }

    @Override
    public void start() {
        this.membershipListener = this.hazelcastInstance.getCluster().addMembershipListener((MembershipListener)this);
        this.lifecycleListener = this.hazelcastInstance.getLifecycleService().addLifecycleListener((LifecycleListener)new HazelcastLifecycleListener(this));
        this.detectNetworkPartitions(PartitionEventType.START_UP, this.hazelcastInstance.getCluster().getMembers().size());
    }

    @Override
    public void stop() {
        this.hazelcastInstance.getCluster().removeMembershipListener(this.membershipListener);
        this.hazelcastInstance.getLifecycleService().removeLifecycleListener(this.lifecycleListener);
    }

    public void networkPartitionMerged() {
        this.detectNetworkPartitions(PartitionEventType.CLUSTER_MERGED, this.hazelcastInstance.getCluster().getMembers().size());
    }

    @Override
    public void clusterOutageOccurred() {
        this.detectNetworkPartitions(PartitionEventType.CLUSTERING_OUTAGE, this.hazelcastInstance.getCluster().getMembers().size());
    }

    private void minimumNodeCountNotFulfilled(int currentClusterSize) {
        for (NetworkPartitionListener listener : this.networkPartitionListeners.values()) {
            try {
                listener.minimumNodeCountNotFulfilled(currentClusterSize);
            }
            catch (Throwable e) {
                this.log.warn((Object)("Error while updating minimum node count not fulfilled for listener: " + listener), e);
            }
        }
    }

    private void minimumNodeCountFulfilled(int currentClusterSize) {
        for (NetworkPartitionListener listener : this.networkPartitionListeners.values()) {
            try {
                listener.minimumNodeCountFulfilled(currentClusterSize);
            }
            catch (Throwable e) {
                this.log.warn((Object)("Error while updating minimum node count fulfilled for listener: " + listener), e);
            }
        }
    }

    public void memberAdded(MembershipEvent membershipEvent) {
        this.detectNetworkPartitions(PartitionEventType.MEMBER_ADDED, membershipEvent.getMembers().size());
    }

    public void memberRemoved(MembershipEvent membershipEvent) {
        this.detectNetworkPartitions(PartitionEventType.MEMBER_REMOVED, membershipEvent.getMembers().size());
    }

    public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
    }

    private void clusteringOutage() {
        for (NetworkPartitionListener listener : this.networkPartitionListeners.values()) {
            listener.clusteringOutage();
        }
    }

    private static enum PartitionEventType {
        START_UP,
        MEMBER_ADDED,
        MEMBER_REMOVED,
        CLUSTER_MERGED,
        CLUSTERING_OUTAGE;

    }
}

