/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster.coordination.rdbms;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesContextStore;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.server.cluster.coordination.rdbms.MembershipEventType;
import org.wso2.andes.server.cluster.coordination.rdbms.MembershipListenerTask;
import org.wso2.andes.server.cluster.coordination.rdbms.RDBMSMembershipListener;

public class RDBMSMembershipEventingEngine {
    private static final Logger logger = Logger.getLogger(RDBMSMembershipEventingEngine.class);
    private AndesContextStore contextStore = AndesContext.getInstance().getAndesContextStore();
    private static ScheduledExecutorService clusterMembershipReaderTaskScheduler;
    private MembershipListenerTask membershipListenerTask;

    public void start(String nodeId) {
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("ClusterEventReaderTask-%d").build();
        clusterMembershipReaderTaskScheduler = Executors.newSingleThreadScheduledExecutor(namedThreadFactory);
        this.membershipListenerTask = new MembershipListenerTask(nodeId);
        int scheduledPeriod = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.RDBMS_BASED_EVENT_POLLING_INTERVAL);
        clusterMembershipReaderTaskScheduler.scheduleWithFixedDelay(this.membershipListenerTask, scheduledPeriod, scheduledPeriod, TimeUnit.MILLISECONDS);
        logger.info((Object)"RDBMS cluster event listener started.");
    }

    public void stop() {
        clusterMembershipReaderTaskScheduler.shutdown();
    }

    public void notifyMembershipEvent(List<String> nodes, MembershipEventType membershipEventType, String nodeID) throws AndesException {
        this.contextStore.storeMembershipEvent(nodes, membershipEventType.getCode(), nodeID);
    }

    public void addEventListener(RDBMSMembershipListener membershipListener) {
        this.membershipListenerTask.addEventListener(membershipListener);
    }

    public void removeEventListener(RDBMSMembershipListener membershipListener) {
        this.membershipListenerTask.removeEventListener(membershipListener);
    }
}

