/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster.coordination.rdbms;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesContextInformationManager;
import org.wso2.andes.kernel.AndesContextStore;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.ClusterNotificationListener;
import org.wso2.andes.kernel.disruptor.inbound.InboundEventManager;
import org.wso2.andes.kernel.subscription.AndesSubscriptionManager;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.cluster.coordination.BindingNotificationHandler;
import org.wso2.andes.server.cluster.coordination.ClusterNotification;
import org.wso2.andes.server.cluster.coordination.ClusterNotificationListenerManager;
import org.wso2.andes.server.cluster.coordination.DBSyncNotificationHandler;
import org.wso2.andes.server.cluster.coordination.ExchangeNotificationHandler;
import org.wso2.andes.server.cluster.coordination.QueueNotificationHandler;
import org.wso2.andes.server.cluster.coordination.SubscriptionNotificationHandler;

public class RDBMSClusterNotificationListenerImpl
implements ClusterNotificationListenerManager {
    private static final Logger log = Logger.getLogger(RDBMSClusterNotificationListenerImpl.class);
    ScheduledExecutorService scheduledExecutorService;
    private AndesContextStore andesContextStore;
    private Map<ClusterNotificationListener.NotifiedArtifact, ClusterNotificationListener> clusterNotificationListeners;
    private String nodeID;

    public RDBMSClusterNotificationListenerImpl(AndesContextStore contextStore) {
        this.andesContextStore = contextStore;
        this.nodeID = ClusterResourceHolder.getInstance().getClusterManager().getMyNodeID();
        this.clusterNotificationListeners = new HashMap<ClusterNotificationListener.NotifiedArtifact, ClusterNotificationListener>(5);
    }

    private void registerNotificationHandler(ClusterNotificationListener.NotifiedArtifact artifactType, ClusterNotificationListener notificationListener) {
        this.clusterNotificationListeners.put(artifactType, notificationListener);
    }

    private void dispatchClusterNotification(ClusterNotification notification) {
        if (!this.nodeID.equals(notification.getOriginatedNode())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received cluster notification " + notification.getEncodedObjectAsString()));
            }
            ClusterNotificationListener.NotifiedArtifact notifiedArtifact = ClusterNotificationListener.NotifiedArtifact.valueOf(notification.getNotifiedArtifact());
            ClusterNotificationListener handlerToDispatch = this.clusterNotificationListeners.get((Object)notifiedArtifact);
            handlerToDispatch.handleClusterNotification(notification);
        }
    }

    @Override
    public void initializeListener(InboundEventManager inboundEventManager, AndesSubscriptionManager subscriptionManager, AndesContextInformationManager contextInformationManager) throws AndesException {
        this.andesContextStore.clearClusterNotifications(this.nodeID);
        this.registerNotificationHandler(ClusterNotificationListener.NotifiedArtifact.MessageRouter, new ExchangeNotificationHandler(contextInformationManager, inboundEventManager));
        this.registerNotificationHandler(ClusterNotificationListener.NotifiedArtifact.Queue, new QueueNotificationHandler(contextInformationManager, inboundEventManager));
        this.registerNotificationHandler(ClusterNotificationListener.NotifiedArtifact.Binding, new BindingNotificationHandler(contextInformationManager, inboundEventManager));
        this.registerNotificationHandler(ClusterNotificationListener.NotifiedArtifact.Subscription, new SubscriptionNotificationHandler(subscriptionManager, inboundEventManager));
        this.registerNotificationHandler(ClusterNotificationListener.NotifiedArtifact.DBUpdate, new DBSyncNotificationHandler());
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("ClusterEventReaderTask-%d").build();
        int clusterEventReaderInterval = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.CLUSTER_EVENT_SYNC_INTERVAL);
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.scheduledExecutorService.scheduleWithFixedDelay(new ClusterEventReaderTask(), clusterEventReaderInterval, clusterEventReaderInterval, TimeUnit.MILLISECONDS);
        log.info((Object)("RDBMS cluster event listener started with an interval of: " + clusterEventReaderInterval + "ms."));
    }

    @Override
    public void reInitializeListener() throws AndesException {
        InboundEventManager eventManager = AndesContext.getInstance().getInboundEventManager();
        AndesSubscriptionManager subscriptionManager = AndesContext.getInstance().getAndesSubscriptionManager();
        AndesContextInformationManager contextInformationManager = AndesContext.getInstance().getAndesContextInformationManager();
        this.initializeListener(eventManager, subscriptionManager, contextInformationManager);
    }

    @Override
    public void stopListener() throws AndesException {
        this.scheduledExecutorService.shutdown();
        log.info((Object)"RDBMS cluster event listener stopped.");
    }

    private class ClusterEventReaderTask
    implements Runnable {
        private ClusterEventReaderTask() {
        }

        @Override
        public void run() {
            try {
                List<ClusterNotification> clusterEvents = RDBMSClusterNotificationListenerImpl.this.andesContextStore.readClusterNotifications(RDBMSClusterNotificationListenerImpl.this.nodeID);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cluster event reader received " + clusterEvents.size() + " events."));
                }
                if (!clusterEvents.isEmpty()) {
                    for (ClusterNotification event : clusterEvents) {
                        RDBMSClusterNotificationListenerImpl.this.dispatchClusterNotification(event);
                    }
                }
            }
            catch (Throwable e) {
                log.warn((Object)"Could not read cluster events. Events will not be reflected in the node until next attempt.", e);
            }
        }
    }
}

