/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster.coordination.rdbms;

import java.util.List;
import org.apache.log4j.Logger;
import org.wso2.andes.kernel.AndesBinding;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesContextStore;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.ClusterNotificationListener;
import org.wso2.andes.kernel.router.AndesMessageRouter;
import org.wso2.andes.kernel.subscription.AndesSubscription;
import org.wso2.andes.kernel.subscription.StorageQueue;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.cluster.coordination.ClusterNotification;
import org.wso2.andes.server.cluster.coordination.ClusterNotificationAgent;

public class RDBMSBasedNotificationAgentImpl
implements ClusterNotificationAgent {
    private static final Logger log = Logger.getLogger(RDBMSBasedNotificationAgentImpl.class);
    private AndesContextStore contextStore;
    private String localNodeID;

    public RDBMSBasedNotificationAgentImpl(AndesContextStore contextStore) {
        this.contextStore = contextStore;
        this.localNodeID = ClusterResourceHolder.getInstance().getClusterManager().getMyNodeID();
    }

    @Override
    public void notifyMessageRouterChange(AndesMessageRouter messageRouter, ClusterNotificationListener.MessageRouterChange changeType) throws AndesException {
        ClusterNotification clusterNotification = new ClusterNotification(messageRouter.encodeAsString(), ClusterNotificationListener.NotifiedArtifact.MessageRouter.toString(), changeType.toString(), "Message Router Notification Message : " + changeType.toString(), this.localNodeID);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending router change GOSSIP: " + (Object)((Object)changeType) + " - " + clusterNotification.getEncodedObjectAsString()));
        }
        this.publishNotificationToDB(clusterNotification);
    }

    @Override
    public void notifyQueueChange(StorageQueue storageQueue, ClusterNotificationListener.QueueChange changeType) throws AndesException {
        ClusterNotification clusterNotification = new ClusterNotification(storageQueue.encodeAsString(), ClusterNotificationListener.NotifiedArtifact.Queue.toString(), changeType.toString(), "Queue Notification Message : " + changeType.toString(), this.localNodeID);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending queue change GOSSIP: " + (Object)((Object)changeType) + " - " + clusterNotification.getEncodedObjectAsString()));
        }
        this.publishNotificationToDB(clusterNotification);
    }

    @Override
    public void notifyBindingsChange(AndesBinding binding, ClusterNotificationListener.BindingChange changeType) throws AndesException {
        ClusterNotification clusterNotification = new ClusterNotification(binding.encodeAsString(), ClusterNotificationListener.NotifiedArtifact.Binding.toString(), changeType.toString(), "Binding Notification Message : " + changeType.toString(), this.localNodeID);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending binding change GOSSIP: " + (Object)((Object)changeType) + " - " + clusterNotification.getEncodedObjectAsString()));
        }
        this.publishNotificationToDB(clusterNotification);
    }

    @Override
    public void notifySubscriptionsChange(AndesSubscription subscription, ClusterNotificationListener.SubscriptionChange changeType) throws AndesException {
        ClusterNotification clusterNotification = new ClusterNotification(subscription.encodeAsStr(), ClusterNotificationListener.NotifiedArtifact.Subscription.toString(), changeType.toString(), "Subscription Notification Message : " + changeType.toString(), this.localNodeID);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending subscription change GOSSIP: " + (Object)((Object)changeType) + " - " + clusterNotification.getEncodedObjectAsString()));
        }
        this.publishNotificationToDB(clusterNotification);
    }

    @Override
    public void notifyAnyDBChange() throws AndesException {
        ClusterNotification clusterNotification = new ClusterNotification("", ClusterNotificationListener.NotifiedArtifact.DBUpdate.toString(), "", "DBSyncEvent", this.localNodeID);
        this.publishNotificationToDB(clusterNotification);
    }

    private void publishNotificationToDB(ClusterNotification event) throws AndesException {
        List<String> clusterNodes = AndesContext.getInstance().getClusterAgent().getAllNodeIdentifiers();
        this.contextStore.storeClusterNotification(clusterNodes, this.localNodeID, event.getNotifiedArtifact(), event.getChangeType(), event.getEncodedObjectAsString(), event.getDescription());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cluster notification " + event.getEncodedObjectAsString() + " stored in Database"));
        }
    }
}

