/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster.coordination.rdbms;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesContextStore;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.server.cluster.coordination.rdbms.MembershipEvent;
import org.wso2.andes.server.cluster.coordination.rdbms.RDBMSMembershipListener;

class MembershipListenerTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(MembershipListenerTask.class);
    private AndesContextStore contextStore = AndesContext.getInstance().getAndesContextStore();
    private String nodeID;
    private List<RDBMSMembershipListener> listeners;

    MembershipListenerTask(String nodeId) {
        this.nodeID = nodeId;
        this.listeners = new ArrayList<RDBMSMembershipListener>();
    }

    @Override
    public void run() {
        try {
            List<MembershipEvent> membershipEvents = this.readMembershipEvents();
            if (!membershipEvents.isEmpty()) {
                block7: for (MembershipEvent event : membershipEvents) {
                    switch (event.getMembershipEventType()) {
                        case MEMBER_ADDED: {
                            this.notifyMemberAddition(event.getMember());
                            continue block7;
                        }
                        case MEMBER_REMOVED: {
                            this.notifyMemberRemoval(event.getMember());
                            continue block7;
                        }
                        case COORDINATOR_CHANGED: {
                            this.notifyCoordinatorChangeEvent(event.getMember());
                            continue block7;
                        }
                    }
                    logger.error((Object)("Unknown cluster event type: " + (Object)((Object)event.getMembershipEventType())));
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)"No membership events to sync");
            }
        }
        catch (Throwable e) {
            logger.warn((Object)"Error occurred while reading membership events.", e);
        }
    }

    private void notifyCoordinatorChangeEvent(String member) {
        for (RDBMSMembershipListener listener : this.listeners) {
            listener.coordinatorChanged(member);
        }
    }

    private void notifyMemberRemoval(String member) {
        for (RDBMSMembershipListener listener : this.listeners) {
            listener.memberRemoved(member);
        }
    }

    private void notifyMemberAddition(String member) {
        for (RDBMSMembershipListener listener : this.listeners) {
            listener.memberAdded(member);
        }
    }

    private List<MembershipEvent> readMembershipEvents() throws AndesException {
        List<MembershipEvent> events = this.contextStore.readMemberShipEvents(this.nodeID);
        return events;
    }

    void addEventListener(RDBMSMembershipListener membershipListener) {
        this.listeners.add(membershipListener);
    }

    void removeEventListener(RDBMSMembershipListener membershipListener) {
        this.listeners.remove(membershipListener);
    }
}

