/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster.coordination.rdbms;

import com.google.common.util.concurrent.SettableFuture;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesContextStore;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.slot.Slot;
import org.wso2.andes.kernel.slot.SlotState;
import org.wso2.andes.server.cluster.coordination.SlotAgent;
import org.wso2.andes.store.AndesDataIntegrityViolationException;
import org.wso2.andes.store.AndesStoreUnavailableException;
import org.wso2.andes.store.FailureObservingStoreManager;
import org.wso2.andes.store.HealthAwareStore;
import org.wso2.andes.store.StoreHealthListener;

public class DatabaseSlotAgent
implements SlotAgent,
StoreHealthListener {
    private volatile SettableFuture<Boolean> messageStoresUnavailable = null;
    private static final Log log = LogFactory.getLog(DatabaseSlotAgent.class);
    private AndesContextStore andesContextStore = AndesContext.getInstance().getAndesContextStore();
    private final int MAX_STORE_FAILURE_TOLERANCE_COUNT = 3;

    public DatabaseSlotAgent() {
        FailureObservingStoreManager.registerStoreHealthListener(this);
    }

    @Override
    public void createSlot(long startMessageId, long endMessageId, String storageQueueName, String assignedNodeId) throws AndesException {
        String task = "create slot with start message id: " + startMessageId + ", end message id: " + endMessageId + " for queue: " + storageQueueName + " and node: " + assignedNodeId;
        for (int attemptCount = 1; attemptCount <= 3; ++attemptCount) {
            this.waitUntilStoresBecomeAvailable(task);
            try {
                this.andesContextStore.createSlot(startMessageId, endMessageId, storageQueueName, assignedNodeId);
                break;
            }
            catch (AndesStoreUnavailableException e) {
                this.handleFailure(attemptCount, task, e);
                continue;
            }
        }
    }

    @Override
    public boolean deleteNonOverlappingSlot(String nodeId, String queueName, long startMessageId, long endMessageId) throws AndesException {
        String task = "delete slot with start message id: " + startMessageId + ", end message id: " + endMessageId + " for queue: " + queueName + " and node: " + nodeId;
        for (int attemptCount = 1; attemptCount <= 3; ++attemptCount) {
            this.waitUntilStoresBecomeAvailable(task);
            try {
                return this.andesContextStore.deleteSlot(startMessageId, endMessageId);
            }
            catch (AndesStoreUnavailableException e) {
                this.handleFailure(attemptCount, task, e);
                continue;
            }
        }
        return false;
    }

    @Override
    public boolean deleteSlot(String nodeId, String queueName, long startMessageId, long endMessageId) throws AndesException {
        String task = "delete slot with start message id: " + startMessageId + ", end message id: " + endMessageId + " for queue: " + queueName + " and node: " + nodeId;
        for (int attemptCount = 1; attemptCount <= 3; ++attemptCount) {
            this.waitUntilStoresBecomeAvailable(task);
            try {
                return this.andesContextStore.deleteSlot(startMessageId, endMessageId);
            }
            catch (AndesStoreUnavailableException e) {
                this.handleFailure(attemptCount, task, e);
                continue;
            }
        }
        return false;
    }

    @Override
    public void deleteSlotAssignmentByQueueName(String nodeId, String queueName) throws AndesException {
        String task = "delete slots for queue: " + queueName + " and node: " + nodeId;
        for (int attemptCount = 1; attemptCount <= 3; ++attemptCount) {
            this.waitUntilStoresBecomeAvailable(task);
            try {
                this.andesContextStore.deleteSlotAssignmentByQueueName(nodeId, queueName);
                break;
            }
            catch (AndesStoreUnavailableException e) {
                this.handleFailure(attemptCount, task, e);
                continue;
            }
        }
    }

    @Override
    public Slot getUnAssignedSlot(String queueName) throws AndesException {
        String task = "retrieve unassigned slot for queue: " + queueName;
        Slot unassignedSlot = null;
        for (int attemptCount = 1; attemptCount <= 3; ++attemptCount) {
            this.waitUntilStoresBecomeAvailable(task);
            try {
                unassignedSlot = this.andesContextStore.selectUnAssignedSlot(queueName);
                break;
            }
            catch (AndesStoreUnavailableException e) {
                this.handleFailure(attemptCount, task, e);
                continue;
            }
        }
        return unassignedSlot;
    }

    @Override
    public void updateSlotAssignment(String nodeId, String queueName, Slot allocatedSlot) throws AndesException {
        String task = "update slot with start message id: " + allocatedSlot.getStartMessageId() + " for queue: " + queueName + " and node: " + nodeId;
        for (int attemptCount = 1; attemptCount <= 3; ++attemptCount) {
            this.waitUntilStoresBecomeAvailable(task);
            try {
                this.andesContextStore.createSlotAssignment(nodeId, queueName, allocatedSlot.getStartMessageId(), allocatedSlot.getEndMessageId());
                break;
            }
            catch (AndesStoreUnavailableException e) {
                this.handleFailure(attemptCount, task, e);
                continue;
            }
        }
    }

    @Override
    public long getQueueToLastAssignedId(String queueName) throws AndesException {
        String task = "get last assigned message id for queue: " + queueName;
        long lastAssignedId = 0L;
        for (int attemptCount = 1; attemptCount <= 3; ++attemptCount) {
            this.waitUntilStoresBecomeAvailable(task);
            try {
                lastAssignedId = this.andesContextStore.getQueueToLastAssignedId(queueName);
                break;
            }
            catch (AndesStoreUnavailableException e) {
                this.handleFailure(attemptCount, task, e);
                continue;
            }
        }
        return lastAssignedId;
    }

    @Override
    public void setQueueToLastAssignedId(String queueName, long lastAssignedId) throws AndesException {
        String task = "set last assigned message id: " + lastAssignedId + " for queue: " + queueName;
        for (int attemptCount = 1; attemptCount <= 3; ++attemptCount) {
            this.waitUntilStoresBecomeAvailable(task);
            try {
                this.andesContextStore.setQueueToLastAssignedId(queueName, lastAssignedId);
                break;
            }
            catch (AndesStoreUnavailableException e) {
                this.handleFailure(attemptCount, task, e);
                continue;
            }
        }
    }

    @Override
    public Long getLocalSafeZoneOfNode(String nodeId) throws AndesException {
        String task = "get last published message id for node: " + nodeId;
        long lastPublishedId = 0L;
        for (int attemptCount = 1; attemptCount <= 3; ++attemptCount) {
            this.waitUntilStoresBecomeAvailable(task);
            try {
                lastPublishedId = this.andesContextStore.getLocalSafeZoneOfNode(nodeId);
                break;
            }
            catch (AndesStoreUnavailableException e) {
                this.handleFailure(attemptCount, task, e);
                continue;
            }
        }
        return lastPublishedId;
    }

    @Override
    public void setLocalSafeZoneOfNode(String nodeId, long localSafeZone) throws AndesException {
        String task = "set local safe zone message id: " + localSafeZone + " for node: " + nodeId;
        for (int attemptCount = 1; attemptCount <= 3; ++attemptCount) {
            this.waitUntilStoresBecomeAvailable(task);
            try {
                this.andesContextStore.setLocalSafeZoneOfNode(nodeId, localSafeZone);
                break;
            }
            catch (AndesStoreUnavailableException e) {
                this.handleFailure(attemptCount, task, e);
                continue;
            }
        }
    }

    @Override
    public void removePublisherNode(String nodeId) throws AndesException {
        String task = "remove publisher node: " + nodeId;
        for (int attemptCount = 1; attemptCount <= 3; ++attemptCount) {
            this.waitUntilStoresBecomeAvailable(task);
            try {
                this.andesContextStore.removePublisherNodeId(nodeId);
                break;
            }
            catch (AndesStoreUnavailableException e) {
                this.handleFailure(attemptCount, task, e);
                continue;
            }
        }
    }

    @Override
    public TreeSet<String> getMessagePublishedNodes() throws AndesException {
        String task = "retrieve publisher nodes";
        TreeSet<String> publishedNodes = new TreeSet<String>();
        for (int attemptCount = 1; attemptCount <= 3; ++attemptCount) {
            this.waitUntilStoresBecomeAvailable(task);
            try {
                publishedNodes = this.andesContextStore.getMessagePublishedNodes();
                break;
            }
            catch (AndesStoreUnavailableException e) {
                this.handleFailure(attemptCount, task, e);
                continue;
            }
        }
        return publishedNodes;
    }

    @Override
    public void setSlotState(long startMessageId, long endMessageId, SlotState slotState) throws AndesException {
        String task = "set state: " + slotState.name() + " to slot with start message id: " + startMessageId + " and end message id: " + endMessageId;
        for (int attemptCount = 1; attemptCount <= 3; ++attemptCount) {
            this.waitUntilStoresBecomeAvailable(task);
            try {
                this.andesContextStore.setSlotState(startMessageId, endMessageId, slotState);
                break;
            }
            catch (AndesStoreUnavailableException e) {
                this.handleFailure(attemptCount, task, e);
                continue;
            }
        }
    }

    @Override
    public Slot getOverlappedSlot(String nodeId, String queueName) throws AndesException {
        String task = "get overlapped slots for queue: " + queueName + " and node: " + nodeId;
        Slot overlappedSlot = null;
        for (int attemptCount = 1; attemptCount <= 3; ++attemptCount) {
            this.waitUntilStoresBecomeAvailable(task);
            try {
                overlappedSlot = this.andesContextStore.getOverlappedSlot(nodeId, queueName);
                break;
            }
            catch (AndesStoreUnavailableException e) {
                this.handleFailure(attemptCount, task, e);
                continue;
            }
        }
        return overlappedSlot;
    }

    @Override
    public void addMessageId(String queueName, long messageId) throws AndesException {
        String task = "add message id: " + messageId + " for queue: " + queueName;
        for (int attemptCount = 1; attemptCount <= 3; ++attemptCount) {
            this.waitUntilStoresBecomeAvailable(task);
            try {
                this.andesContextStore.addMessageId(queueName, messageId);
                break;
            }
            catch (AndesDataIntegrityViolationException andesDataIntegrityViolationException) {
                continue;
            }
            catch (AndesStoreUnavailableException e) {
                this.handleFailure(attemptCount, task, e);
            }
        }
    }

    @Override
    public TreeSet<Long> getSlotBasedMessageIds(String queueName) throws AndesException {
        String task = "get message ids for queue: " + queueName;
        TreeSet<Long> messageIds = new TreeSet<Long>();
        for (int attemptCount = 1; attemptCount <= 3; ++attemptCount) {
            this.waitUntilStoresBecomeAvailable(task);
            try {
                messageIds = this.andesContextStore.getMessageIds(queueName);
                break;
            }
            catch (AndesStoreUnavailableException e) {
                this.handleFailure(attemptCount, task, e);
                continue;
            }
        }
        return messageIds;
    }

    @Override
    public void deleteMessageId(String queueName, long messageId) throws AndesException {
        String task = "delete slot with start message id: " + messageId + " for queue: " + queueName;
        for (int attemptCount = 1; attemptCount <= 3; ++attemptCount) {
            this.waitUntilStoresBecomeAvailable(task);
            try {
                this.andesContextStore.deleteMessageId(messageId);
                break;
            }
            catch (AndesStoreUnavailableException e) {
                this.handleFailure(attemptCount, task, e);
                continue;
            }
        }
    }

    @Override
    public void deleteSlotsByQueueName(String queueName) throws AndesException {
        String task = "delete slot assignments for queue: " + queueName;
        for (int attemptCount = 1; attemptCount <= 3; ++attemptCount) {
            this.waitUntilStoresBecomeAvailable(task);
            try {
                this.andesContextStore.deleteSlotsByQueueName(queueName);
                break;
            }
            catch (AndesStoreUnavailableException e) {
                this.handleFailure(attemptCount, task, e);
                continue;
            }
        }
    }

    @Override
    public void deleteMessageIdsByQueueName(String queueName) throws AndesException {
        String task = "delete slots for queue: " + queueName;
        for (int attemptCount = 1; attemptCount <= 3; ++attemptCount) {
            this.waitUntilStoresBecomeAvailable(task);
            try {
                this.andesContextStore.deleteMessageIdsByQueueName(queueName);
                break;
            }
            catch (AndesStoreUnavailableException e) {
                this.handleFailure(attemptCount, task, e);
                continue;
            }
        }
    }

    @Override
    public TreeSet<Slot> getAssignedSlotsByNodeId(String nodeId) throws AndesException {
        String task = "retrieve assigned slots for node: " + nodeId;
        TreeSet<Slot> assignedSlots = new TreeSet<Slot>();
        for (int attemptCount = 1; attemptCount <= 3; ++attemptCount) {
            this.waitUntilStoresBecomeAvailable(task);
            try {
                assignedSlots = this.andesContextStore.getAssignedSlotsByNodeId(nodeId);
                break;
            }
            catch (AndesStoreUnavailableException e) {
                this.handleFailure(attemptCount, task, e);
                continue;
            }
        }
        return assignedSlots;
    }

    @Override
    public TreeSet<Slot> getOverlappedSlotsByNodeId(String nodeId) throws AndesException {
        String task = "retrieve overlapped slots for node: " + nodeId;
        TreeSet<Slot> overlappedSlots = new TreeSet<Slot>();
        for (int attemptCount = 1; attemptCount <= 3; ++attemptCount) {
            this.waitUntilStoresBecomeAvailable(task);
            try {
                overlappedSlots = this.andesContextStore.getOverlappedSlotsByNodeId(nodeId);
                break;
            }
            catch (AndesStoreUnavailableException e) {
                this.handleFailure(attemptCount, task, e);
                continue;
            }
        }
        return overlappedSlots;
    }

    @Override
    public TreeSet<Slot> getAllSlotsByQueueName(String queueName) throws AndesException {
        String task = "retrieve all slots for queue: " + queueName;
        TreeSet<Slot> allSlotsForQueue = new TreeSet<Slot>();
        for (int attemptCount = 1; attemptCount <= 3; ++attemptCount) {
            this.waitUntilStoresBecomeAvailable(task);
            try {
                allSlotsForQueue = this.andesContextStore.getAllSlotsByQueueName(queueName);
                break;
            }
            catch (AndesStoreUnavailableException e) {
                this.handleFailure(attemptCount, task, e);
                continue;
            }
        }
        return allSlotsForQueue;
    }

    @Override
    public void reassignSlot(Slot slotToBeReassigned) throws AndesException {
        String task = "delete slot assignment with start message id: " + slotToBeReassigned.getStartMessageId() + " and end message id: " + slotToBeReassigned.getEndMessageId();
        for (int attemptCount = 1; attemptCount <= 3; ++attemptCount) {
            this.waitUntilStoresBecomeAvailable(task);
            try {
                this.andesContextStore.deleteSlotAssignment(slotToBeReassigned.getStartMessageId(), slotToBeReassigned.getEndMessageId());
                break;
            }
            catch (AndesStoreUnavailableException e) {
                this.handleFailure(attemptCount, task, e);
                continue;
            }
        }
    }

    @Override
    public void deleteOverlappedSlots(String nodeId) throws AndesException {
    }

    @Override
    public void updateOverlappedSlots(String queueName, TreeSet<Slot> overlappedSlots) throws AndesException {
        for (Slot slot : overlappedSlots) {
            this.setSlotState(slot.getStartMessageId(), slot.getEndMessageId(), SlotState.OVERLAPPED);
        }
    }

    @Override
    public Set<String> getAllQueues() throws AndesException {
        String task = "retrieve all queue";
        Set<String> allQueues = new HashSet<String>();
        for (int attemptCount = 1; attemptCount <= 3; ++attemptCount) {
            this.waitUntilStoresBecomeAvailable(task);
            try {
                allQueues = this.andesContextStore.getAllQueues();
                break;
            }
            catch (AndesStoreUnavailableException e) {
                this.handleFailure(attemptCount, task, e);
                continue;
            }
        }
        return allQueues;
    }

    @Override
    public Set<String> getAllQueuesInSubmittedSlots() throws AndesException {
        String task = "retrieve all queues in submitted slots";
        Set<String> allQueues = new HashSet<String>();
        for (int attemptCount = 1; attemptCount <= 3; ++attemptCount) {
            this.waitUntilStoresBecomeAvailable(task);
            try {
                allQueues = this.andesContextStore.getAllQueuesInSubmittedSlots();
                break;
            }
            catch (AndesStoreUnavailableException e) {
                this.handleFailure(attemptCount, task, e);
                continue;
            }
        }
        return allQueues;
    }

    @Override
    public void clearSlotStorage() throws AndesException {
        String task = "clear slot storage";
        for (int attemptCount = 1; attemptCount <= 3; ++attemptCount) {
            this.waitUntilStoresBecomeAvailable(task);
            try {
                this.andesContextStore.clearSlotStorage();
                break;
            }
            catch (AndesStoreUnavailableException e) {
                this.handleFailure(attemptCount, task, e);
                continue;
            }
        }
    }

    private void waitUntilStoresBecomeAvailable(String task) throws AndesException {
        if (null != this.messageStoresUnavailable) {
            log.info((Object)("Context store has become unavailable while trying to " + task + " therefore waiting until stores become available. thread id: " + Thread.currentThread().getId()));
            try {
                this.messageStoresUnavailable.get();
                this.messageStoresUnavailable = null;
            }
            catch (InterruptedException e) {
                throw new AndesException("Thread interrupted while waiting for message stores to come online", e);
            }
            catch (ExecutionException e) {
                throw new AndesException("Error occurred while waiting for message stores to come online", e);
            }
        }
    }

    private void handleFailure(int attemptCount, String operation, AndesStoreUnavailableException exception) throws AndesException {
        if (3 == attemptCount) {
            log.info((Object)("Number of maximum tolerances of store failure has been reached while trying to " + operation + ". Aborting operation"));
            throw exception;
        }
    }

    @Override
    public void storeOperational(HealthAwareStore store) {
        log.info((Object)"Context store became operational. Therefore, resuming Database Slot Agent");
        this.messageStoresUnavailable.set((Object)false);
    }

    @Override
    public void storeNonOperational(HealthAwareStore store, Exception ex) {
        log.info((Object)"Context store became non-operational. Therefore, blocking Database Slot Agent");
        this.messageStoresUnavailable = SettableFuture.create();
    }
}

