/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster.coordination.hazelcast;

import com.hazelcast.core.ITopic;
import com.hazelcast.core.MessageListener;
import org.apache.commons.lang.StringUtils;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesContextInformationManager;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.disruptor.inbound.InboundEventManager;
import org.wso2.andes.kernel.subscription.AndesSubscriptionManager;
import org.wso2.andes.server.cluster.coordination.BindingNotificationHandler;
import org.wso2.andes.server.cluster.coordination.ClusterNotification;
import org.wso2.andes.server.cluster.coordination.ClusterNotificationListenerManager;
import org.wso2.andes.server.cluster.coordination.CoordinationConstants;
import org.wso2.andes.server.cluster.coordination.DBSyncNotificationHandler;
import org.wso2.andes.server.cluster.coordination.ExchangeNotificationHandler;
import org.wso2.andes.server.cluster.coordination.QueueNotificationHandler;
import org.wso2.andes.server.cluster.coordination.SubscriptionNotificationHandler;
import org.wso2.andes.server.cluster.coordination.hazelcast.HZBasedClusterNotificationListener;
import org.wso2.andes.server.cluster.coordination.hazelcast.HZBasedDatabaseSyncNotificationListener;
import org.wso2.andes.server.cluster.coordination.hazelcast.HazelcastAgent;

public class HazelcastClusterNotificationListenerImpl
implements ClusterNotificationListenerManager {
    private ITopic<ClusterNotification> dbSyncNotifierChannel;
    private ITopic<ClusterNotification> clusterNotifierChannel;
    private String dbSyncNotificationListenerId;
    private String clusterEventListenerId;
    private HazelcastAgent hazelcastAgent;
    private final int HAZELCAST_RELIABLE_TOPIC_READ_BACH_SIZE = 5;
    private final int HAZELCAST_RING_BUFFER_CAPACITY = 1000;
    private final boolean ENABLE_STATISTICS = false;

    public HazelcastClusterNotificationListenerImpl(HazelcastAgent hazelcastAgent) {
        this.hazelcastAgent = hazelcastAgent;
        this.addTopics();
    }

    @Override
    public void initializeListener(InboundEventManager inboundEventManager, AndesSubscriptionManager subscriptionManager, AndesContextInformationManager contextInformationManager) throws AndesException {
        this.addTopicListeners(inboundEventManager, subscriptionManager, contextInformationManager);
    }

    @Override
    public void reInitializeListener() throws AndesException {
        this.addTopics();
        InboundEventManager eventManager = AndesContext.getInstance().getInboundEventManager();
        AndesSubscriptionManager subscriptionManager = AndesContext.getInstance().getAndesSubscriptionManager();
        AndesContextInformationManager contextInformationManager = AndesContext.getInstance().getAndesContextInformationManager();
        this.addTopicListeners(eventManager, subscriptionManager, contextInformationManager);
    }

    @Override
    public void stopListener() throws AndesException {
    }

    private void addTopics() {
        int hazelcastRingBufferTTL = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.COORDINATION_CLUSTER_NOTIFICATION_TIMEOUT);
        this.dbSyncNotifierChannel = this.hazelcastAgent.createReliableTopic(CoordinationConstants.HAZELCAST_DB_SYNC_NOTIFICATION_TOPIC_NAME, false, 5, 1000, hazelcastRingBufferTTL);
        this.clusterNotifierChannel = this.hazelcastAgent.createReliableTopic(CoordinationConstants.HAZELCAST_CLUSTER_EVENT_NOTIFIER_TOPIC_NAME, false, 5, 1000, hazelcastRingBufferTTL);
    }

    private void addTopicListeners(InboundEventManager inboundEventManager, AndesSubscriptionManager subscriptionManager, AndesContextInformationManager contextInformationManager) throws AndesException {
        HZBasedClusterNotificationListener hzBasedClusterNotificationListener = new HZBasedClusterNotificationListener();
        hzBasedClusterNotificationListener.addSubscriptionNotificationHandler(new SubscriptionNotificationHandler(subscriptionManager, inboundEventManager));
        hzBasedClusterNotificationListener.addBindingNotificationHandler(new BindingNotificationHandler(contextInformationManager, inboundEventManager));
        hzBasedClusterNotificationListener.addExchangeNotificationHandler(new ExchangeNotificationHandler(contextInformationManager, inboundEventManager));
        hzBasedClusterNotificationListener.addQueueNotificationHandler(new QueueNotificationHandler(contextInformationManager, inboundEventManager));
        this.clusterEventListenerId = this.checkAndRegisterListerToTopic(this.clusterNotifierChannel, hzBasedClusterNotificationListener, this.clusterEventListenerId);
        HZBasedDatabaseSyncNotificationListener HZBasedDatabaseSyncNotificationListener2 = new HZBasedDatabaseSyncNotificationListener();
        HZBasedDatabaseSyncNotificationListener2.addHandler(new DBSyncNotificationHandler());
        this.dbSyncNotificationListenerId = this.checkAndRegisterListerToTopic(this.dbSyncNotifierChannel, HZBasedDatabaseSyncNotificationListener2, this.dbSyncNotificationListenerId);
    }

    private String checkAndRegisterListerToTopic(ITopic<ClusterNotification> topic, MessageListener<ClusterNotification> listener, String listenerId) {
        if (StringUtils.isNotEmpty((String)listenerId)) {
            topic.removeMessageListener(listenerId);
        }
        return topic.addMessageListener(listener);
    }

    public ITopic<ClusterNotification> getClusterNotificationChannel() {
        return this.clusterNotifierChannel;
    }

    public ITopic<ClusterNotification> getDBSyncNotificationChannel() {
        return this.dbSyncNotifierChannel;
    }
}

