/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster.coordination.hazelcast;

import com.hazelcast.core.ITopic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesBinding;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.ClusterNotificationListener;
import org.wso2.andes.kernel.router.AndesMessageRouter;
import org.wso2.andes.kernel.subscription.AndesSubscription;
import org.wso2.andes.kernel.subscription.StorageQueue;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.cluster.coordination.ClusterNotification;
import org.wso2.andes.server.cluster.coordination.ClusterNotificationAgent;

public class HazelcastBasedNotificationAgentImpl
implements ClusterNotificationAgent {
    private static Log log = LogFactory.getLog(HazelcastBasedNotificationAgentImpl.class);
    private ITopic<ClusterNotification> clusterNotificationChannel;
    private ITopic<ClusterNotification> dbSyncNotificationChannel;
    private String localNodeID = ClusterResourceHolder.getInstance().getClusterManager().getMyNodeID();

    public HazelcastBasedNotificationAgentImpl(ITopic<ClusterNotification> clusterNotificationChannel, ITopic<ClusterNotification> dbSyncNotificationChannel) {
        this.clusterNotificationChannel = clusterNotificationChannel;
        this.dbSyncNotificationChannel = dbSyncNotificationChannel;
    }

    @Override
    public void notifyMessageRouterChange(AndesMessageRouter messageRouter, ClusterNotificationListener.MessageRouterChange changeType) throws AndesException {
        ClusterNotification clusterNotification = new ClusterNotification(messageRouter.encodeAsString(), ClusterNotificationListener.NotifiedArtifact.MessageRouter.toString(), changeType.toString(), "Message Router Notification Message : " + changeType.toString(), this.localNodeID);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending router change GOSSIP: " + (Object)((Object)changeType) + " - " + clusterNotification.getEncodedObjectAsString()));
        }
        try {
            this.clusterNotificationChannel.publish((Object)clusterNotification);
        }
        catch (Exception e) {
            log.error((Object)("Error while sending exchange change notification" + clusterNotification.getEncodedObjectAsString()), (Throwable)e);
            throw new AndesException("Error while sending exchange change notification" + clusterNotification.getEncodedObjectAsString(), e);
        }
    }

    @Override
    public void notifyQueueChange(StorageQueue andesQueue, ClusterNotificationListener.QueueChange changeType) throws AndesException {
        ClusterNotification clusterNotification = new ClusterNotification(andesQueue.encodeAsString(), ClusterNotificationListener.NotifiedArtifact.Queue.toString(), changeType.toString(), "Queue Notification Message : " + changeType.toString(), this.localNodeID);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending queue change GOSSIP: " + (Object)((Object)changeType) + " - " + clusterNotification.getEncodedObjectAsString()));
        }
        try {
            this.clusterNotificationChannel.publish((Object)clusterNotification);
        }
        catch (Exception e) {
            log.error((Object)("Error while sending queue change notification : " + clusterNotification.getEncodedObjectAsString()), (Throwable)e);
            throw new AndesException("Error while sending queue change notification : " + clusterNotification.getEncodedObjectAsString(), e);
        }
    }

    @Override
    public void notifyBindingsChange(AndesBinding binding, ClusterNotificationListener.BindingChange changeType) throws AndesException {
        ClusterNotification clusterNotification = new ClusterNotification(binding.encodeAsString(), ClusterNotificationListener.NotifiedArtifact.Binding.toString(), changeType.toString(), "Binding Notification Message : " + changeType.toString(), this.localNodeID);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending binding change GOSSIP: " + (Object)((Object)changeType) + " - " + clusterNotification.getEncodedObjectAsString()));
        }
        try {
            this.clusterNotificationChannel.publish((Object)clusterNotification);
        }
        catch (Exception e) {
            log.error((Object)("Error while sending binding change notification" + clusterNotification.getEncodedObjectAsString()), (Throwable)e);
            throw new AndesException("Error while sending binding change notification" + clusterNotification.getEncodedObjectAsString(), e);
        }
    }

    @Override
    public void notifySubscriptionsChange(AndesSubscription subscription, ClusterNotificationListener.SubscriptionChange changeType) throws AndesException {
        ClusterNotification clusterNotification = new ClusterNotification(subscription.encodeAsStr(), ClusterNotificationListener.NotifiedArtifact.Subscription.toString(), changeType.toString(), "Subscription Notification Message : " + changeType.toString(), this.localNodeID);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending subscription change GOSSIP: " + (Object)((Object)changeType) + " - " + clusterNotification.getEncodedObjectAsString()));
        }
        try {
            this.clusterNotificationChannel.publish((Object)clusterNotification);
        }
        catch (Exception ex) {
            log.error((Object)("Error while sending subscription change notification : " + clusterNotification.getEncodedObjectAsString()), (Throwable)ex);
            throw new AndesException("Error while sending queue change notification : " + clusterNotification.getEncodedObjectAsString(), ex);
        }
    }

    @Override
    public void notifyAnyDBChange() throws AndesException {
        ClusterNotification clusterNotification = new ClusterNotification("", ClusterNotificationListener.NotifiedArtifact.DBUpdate.toString(), "", "DBSyncEvent", this.localNodeID);
        try {
            this.dbSyncNotificationChannel.publish((Object)clusterNotification);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Requested for DB sync across the cluster.");
            }
        }
        catch (Exception e) {
            log.error((Object)("Error while sending db sync notification" + clusterNotification.getEncodedObjectAsString()), (Throwable)e);
            throw new AndesException("Error while sending db sync notification" + clusterNotification.getEncodedObjectAsString(), e);
        }
    }
}

