/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster.coordination.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.config.ReliableTopicConfig;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.ILock;
import com.hazelcast.core.ITopic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.server.cluster.CoordinationConfigurableClusterAgent;
import org.wso2.andes.server.cluster.coordination.ClusterNotification;

public class HazelcastAgent {
    private static final Log log = LogFactory.getLog(HazelcastAgent.class);
    private static final long INIT_SUCCESSFUL = 1L;
    private static HazelcastAgent hazelcastAgentInstance = new HazelcastAgent();
    private HazelcastInstance hazelcastInstance;
    private ILock initializationLock;
    private IAtomicLong initializationDoneIndicator;

    private HazelcastAgent() {
    }

    public static synchronized HazelcastAgent getInstance() {
        return hazelcastAgentInstance;
    }

    public void init(HazelcastInstance hazelcastInstance) {
        log.info((Object)"Initializing Hazelcast Agent");
        this.hazelcastInstance = hazelcastInstance;
        CoordinationConfigurableClusterAgent clusterAgent = new CoordinationConfigurableClusterAgent(hazelcastInstance);
        AndesContext.getInstance().setClusterAgent(clusterAgent);
        this.initializationLock = hazelcastInstance.getLock("InitializationLock");
        this.initializationDoneIndicator = hazelcastInstance.getAtomicLong("InitializationDone");
        log.info((Object)"Successfully initialized Hazelcast Agent");
    }

    ITopic<ClusterNotification> createReliableTopic(String topicName, boolean enableStatistics, int readBatchSize, int capacity, int timeToLive) {
        this.addReliableTopicConfig(topicName, enableStatistics, readBatchSize);
        this.addRingBufferConfig(topicName, capacity, timeToLive);
        return this.hazelcastInstance.getReliableTopic(topicName);
    }

    public void acquireInitializationLock() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Trying to acquire initialization lock.");
        }
        this.initializationLock.lock();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initialization lock acquired.");
        }
    }

    public void indicateSuccessfulInitilization() {
        this.initializationDoneIndicator.set(1L);
    }

    public boolean isClusterInitializedSuccessfully() {
        return this.initializationDoneIndicator.get() == 1L;
    }

    public void releaseInitializationLock() {
        this.initializationLock.unlock();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initialization lock released.");
        }
    }

    public boolean isActive() {
        if (null != this.hazelcastInstance) {
            return this.hazelcastInstance.getLifecycleService().isRunning();
        }
        return false;
    }

    private void addReliableTopicConfig(String reliableTopicName, boolean enableStatistics, int readBatchSize) {
        Config config = this.hazelcastInstance.getConfig();
        ReliableTopicConfig topicConfig = new ReliableTopicConfig(reliableTopicName);
        topicConfig.setStatisticsEnabled(enableStatistics);
        topicConfig.setReadBatchSize(readBatchSize);
        config.addReliableTopicConfig(topicConfig);
    }

    private void addRingBufferConfig(String ringBufferName, int capacity, int timeToLive) {
        Config config = this.hazelcastInstance.getConfig();
        RingbufferConfig ringConfig = new RingbufferConfig(ringBufferName);
        ringConfig.setCapacity(capacity);
        ringConfig.setTimeToLiveSeconds(timeToLive);
        config.addRingBufferConfig(ringConfig);
    }
}

