/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster.coordination.hazelcast;

import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.server.cluster.coordination.ClusterNotification;
import org.wso2.andes.server.cluster.coordination.DBSyncNotificationHandler;

public class HZBasedDatabaseSyncNotificationListener
implements MessageListener {
    private static Log log = LogFactory.getLog(HZBasedDatabaseSyncNotificationListener.class);
    private List<DBSyncNotificationHandler> dbSyncNotificationListeners = new ArrayList<DBSyncNotificationHandler>();

    public void addHandler(DBSyncNotificationHandler listener) {
        this.dbSyncNotificationListeners.add(listener);
    }

    public void onMessage(Message message) {
        ClusterNotification clusterNotification = (ClusterNotification)message.getMessageObject();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Handling cluster gossip: received a DB sync request " + clusterNotification.getEncodedObjectAsString()));
        }
        log.info((Object)("DB sync request received after a split brain recovery from cluster " + message.getPublishingMember()));
        for (DBSyncNotificationHandler dbSyncNotificationListener : this.dbSyncNotificationListeners) {
            dbSyncNotificationListener.handleClusterNotification(clusterNotification);
        }
        log.info((Object)("DB sync completed for the request from cluster " + message.getPublishingMember()));
    }
}

