/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster.coordination.hazelcast;

import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.server.cluster.coordination.BindingNotificationHandler;
import org.wso2.andes.server.cluster.coordination.ClusterNotification;
import org.wso2.andes.server.cluster.coordination.ExchangeNotificationHandler;
import org.wso2.andes.server.cluster.coordination.QueueNotificationHandler;
import org.wso2.andes.server.cluster.coordination.SubscriptionNotificationHandler;
import org.wso2.andes.server.cluster.coordination.hazelcast.HZBasedDatabaseSyncNotificationListener;

public class HZBasedClusterNotificationListener
implements MessageListener {
    private static Log log = LogFactory.getLog(HZBasedDatabaseSyncNotificationListener.class);
    private List<ExchangeNotificationHandler> exchangeNotificationHandlerList = new ArrayList<ExchangeNotificationHandler>();
    private List<QueueNotificationHandler> queueNotificationHandlerList = new ArrayList<QueueNotificationHandler>();
    private List<BindingNotificationHandler> bindingNotificationHandlerList = new ArrayList<BindingNotificationHandler>();
    private List<SubscriptionNotificationHandler> subscriptionNotificationHandlerList = new ArrayList<SubscriptionNotificationHandler>();

    public void addExchangeNotificationHandler(ExchangeNotificationHandler handler) {
        this.exchangeNotificationHandlerList.add(handler);
    }

    public void addQueueNotificationHandler(QueueNotificationHandler handler) {
        this.queueNotificationHandlerList.add(handler);
    }

    public void addBindingNotificationHandler(BindingNotificationHandler handler) {
        this.bindingNotificationHandlerList.add(handler);
    }

    public void addSubscriptionNotificationHandler(SubscriptionNotificationHandler handler) {
        this.subscriptionNotificationHandlerList.add(handler);
    }

    public void onMessage(Message message) {
        if (!message.getPublishingMember().localMember()) {
            ClusterNotification clusterNotification = (ClusterNotification)message.getMessageObject();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Handling cluster gossip: received cluster notification: " + clusterNotification.getEncodedObjectAsString() + " for artifact: " + clusterNotification.getNotifiedArtifact() + " with change type: " + clusterNotification.getChangeType()));
            }
            switch (clusterNotification.getNotifiedArtifact()) {
                case "MessageRouter": {
                    for (ExchangeNotificationHandler handler : this.exchangeNotificationHandlerList) {
                        handler.handleClusterNotification(clusterNotification);
                    }
                    break;
                }
                case "Binding": {
                    for (BindingNotificationHandler handler : this.bindingNotificationHandlerList) {
                        handler.handleClusterNotification(clusterNotification);
                    }
                    break;
                }
                case "Queue": {
                    for (QueueNotificationHandler handler : this.queueNotificationHandlerList) {
                        handler.handleClusterNotification(clusterNotification);
                    }
                    break;
                }
                case "Subscription": {
                    for (SubscriptionNotificationHandler handler : this.subscriptionNotificationHandlerList) {
                        handler.handleClusterNotification(clusterNotification);
                    }
                    break;
                }
                default: {
                    log.error((Object)("Unknown cluster event type: " + clusterNotification.getNotifiedArtifact()));
                }
            }
        }
    }
}

