/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster.coordination;

import java.util.concurrent.atomic.AtomicInteger;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.cluster.coordination.MessageIdGenerator;

public class TimeStampBasedMessageIdGenerator
implements MessageIdGenerator {
    private int uniqueIdForNode = 0;
    private long lastTimestamp = 0L;
    private long lastID = 0L;
    private AtomicInteger offset = new AtomicInteger();
    private static final long REFERENCE_START = 1292976000000L;

    @Override
    public synchronized long getNextId() {
        this.uniqueIdForNode = ClusterResourceHolder.getInstance().getClusterManager().getUniqueIdForLocalNode();
        long ts = System.currentTimeMillis();
        int offset = 0;
        if (ts == this.lastTimestamp) {
            offset = this.offset.incrementAndGet();
        } else {
            this.offset.set(0);
        }
        this.lastTimestamp = ts;
        long id = (ts - 1292976000000L) * 256L * 1024L + (long)(this.uniqueIdForNode * 1024) + (long)offset;
        if (this.lastID == id) {
            throw new RuntimeException("duplicate ids detected. This should never happen");
        }
        this.lastID = id;
        return id;
    }
}

