/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster.coordination;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.ClusterNotificationListener;
import org.wso2.andes.kernel.disruptor.inbound.InboundEventManager;
import org.wso2.andes.kernel.disruptor.inbound.InboundSubscriptionSyncEvent;
import org.wso2.andes.kernel.subscription.AndesSubscriptionManager;
import org.wso2.andes.server.cluster.coordination.ClusterNotification;

public class SubscriptionNotificationHandler
implements ClusterNotificationListener {
    private Log log = LogFactory.getLog(SubscriptionNotificationHandler.class);
    private AndesSubscriptionManager subscriptionManager;
    private InboundEventManager inboundEventManager;

    public SubscriptionNotificationHandler(AndesSubscriptionManager subscriptionManager, InboundEventManager eventManager) {
        this.subscriptionManager = subscriptionManager;
        this.inboundEventManager = eventManager;
    }

    @Override
    public void handleClusterNotification(ClusterNotification notification) {
        try {
            InboundSubscriptionSyncEvent subscriptionSyncEvent = new InboundSubscriptionSyncEvent(notification.getEncodedObjectAsString());
            ClusterNotificationListener.SubscriptionChange changeType = ClusterNotificationListener.SubscriptionChange.valueOf(notification.getChangeType());
            switch (changeType) {
                case Added: {
                    subscriptionSyncEvent.prepareForRemoteSubscriptionAdd(this.subscriptionManager);
                    this.inboundEventManager.publishStateEvent(subscriptionSyncEvent);
                    subscriptionSyncEvent.waitForCompletion();
                    break;
                }
                case Closed: {
                    subscriptionSyncEvent.prepareForRemoteSubscriptionClose(this.subscriptionManager);
                    this.inboundEventManager.publishStateEvent(subscriptionSyncEvent);
                    subscriptionSyncEvent.waitForCompletion();
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error while handling subscription notification", (Throwable)e);
        }
    }
}

