/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster.coordination;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesContextInformationManager;
import org.wso2.andes.kernel.ClusterNotificationListener;
import org.wso2.andes.kernel.disruptor.inbound.InboundEventManager;
import org.wso2.andes.kernel.disruptor.inbound.InboundQueueSyncEvent;
import org.wso2.andes.server.cluster.coordination.ClusterNotification;

public class QueueNotificationHandler
implements ClusterNotificationListener {
    private Log log = LogFactory.getLog(QueueNotificationHandler.class);
    private AndesContextInformationManager contextInformationManager;
    private InboundEventManager inboundEventManager;

    public QueueNotificationHandler(AndesContextInformationManager contextInformationManager, InboundEventManager inboundEventManager) {
        this.contextInformationManager = contextInformationManager;
        this.inboundEventManager = inboundEventManager;
    }

    @Override
    public void handleClusterNotification(ClusterNotification notification) {
        try {
            InboundQueueSyncEvent queueSyncEvent = new InboundQueueSyncEvent(notification.getEncodedObjectAsString());
            ClusterNotificationListener.QueueChange changeType = ClusterNotificationListener.QueueChange.valueOf(notification.getChangeType());
            switch (changeType) {
                case Added: {
                    queueSyncEvent.prepareForSyncCreateQueue(this.contextInformationManager);
                    this.inboundEventManager.publishStateEvent(queueSyncEvent);
                    break;
                }
                case Deleted: {
                    queueSyncEvent.prepareForSyncDeleteQueue(this.contextInformationManager);
                    this.inboundEventManager.publishStateEvent(queueSyncEvent);
                    break;
                }
                case Purged: {
                    queueSyncEvent.prepareForSyncPurgeQueue(this.contextInformationManager);
                    this.inboundEventManager.publishStateEvent(queueSyncEvent);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error while handling queue notification", (Throwable)e);
        }
    }
}

