/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster.coordination;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesContextInformationManager;
import org.wso2.andes.kernel.ClusterNotificationListener;
import org.wso2.andes.kernel.disruptor.inbound.InboundEventManager;
import org.wso2.andes.kernel.disruptor.inbound.InboundExchangeSyncEvent;
import org.wso2.andes.server.cluster.coordination.ClusterNotification;

public class ExchangeNotificationHandler
implements ClusterNotificationListener {
    private Log log = LogFactory.getLog(ExchangeNotificationHandler.class);
    private AndesContextInformationManager contextInformationManager;
    private InboundEventManager inboundEventManager;

    public ExchangeNotificationHandler(AndesContextInformationManager contextInformationManager, InboundEventManager inboundEventManager) {
        this.contextInformationManager = contextInformationManager;
        this.inboundEventManager = inboundEventManager;
    }

    @Override
    public void handleClusterNotification(ClusterNotification notification) {
        try {
            InboundExchangeSyncEvent exchangeSyncEvent = new InboundExchangeSyncEvent(notification.getEncodedObjectAsString());
            ClusterNotificationListener.MessageRouterChange changeType = ClusterNotificationListener.MessageRouterChange.valueOf(notification.getChangeType());
            switch (changeType) {
                case Added: {
                    exchangeSyncEvent.prepareForCreateExchangeSync(this.contextInformationManager);
                    this.inboundEventManager.publishStateEvent(exchangeSyncEvent);
                    break;
                }
                case Deleted: {
                    exchangeSyncEvent.prepareForDeleteExchangeSync(this.contextInformationManager);
                    this.inboundEventManager.publishStateEvent(exchangeSyncEvent);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error while handling exchange notification", (Throwable)e);
        }
    }
}

