/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster.coordination;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesContextStore;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.cluster.coordination.ClusterNotificationAgent;
import org.wso2.andes.server.cluster.coordination.ClusterNotificationListenerManager;
import org.wso2.andes.server.cluster.coordination.StandaloneMockNotificationAgent;
import org.wso2.andes.server.cluster.coordination.hazelcast.HazelcastAgent;
import org.wso2.andes.server.cluster.coordination.hazelcast.HazelcastBasedNotificationAgentImpl;
import org.wso2.andes.server.cluster.coordination.hazelcast.HazelcastClusterNotificationListenerImpl;
import org.wso2.andes.server.cluster.coordination.rdbms.RDBMSBasedNotificationAgentImpl;
import org.wso2.andes.server.cluster.coordination.rdbms.RDBMSClusterNotificationListenerImpl;

public class CoordinationComponentFactory {
    private Log log = LogFactory.getLog(CoordinationComponentFactory.class);
    private boolean isRDBMSBasedCoordinationEnabled;
    private boolean isClusteringEnabled;

    public ClusterNotificationListenerManager createClusterNotificationListener() throws AndesException {
        ClusterNotificationListenerManager clusterNotificationListenerManager;
        this.initConfiguration();
        if (ClusterResourceHolder.getInstance().getClusterManager().isClusteringEnabled()) {
            if (this.isRDBMSBasedCoordinationEnabled) {
                this.log.info((Object)"Broker is initialized with RDBMS based cluster event synchronization.");
                AndesContextStore contextStore = AndesContext.getInstance().getAndesContextStore();
                clusterNotificationListenerManager = new RDBMSClusterNotificationListenerImpl(contextStore);
            } else {
                this.log.info((Object)"Broker is initialized with HAZELCAST based cluster event synchronization.");
                clusterNotificationListenerManager = new HazelcastClusterNotificationListenerImpl(HazelcastAgent.getInstance());
            }
        } else {
            clusterNotificationListenerManager = null;
        }
        return clusterNotificationListenerManager;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ClusterNotificationAgent createClusterNotificationAgent() throws AndesException {
        void var2_5;
        this.initConfiguration();
        AndesContextStore contextStore = AndesContext.getInstance().getAndesContextStore();
        if (this.isClusteringEnabled) {
            if (this.isRDBMSBasedCoordinationEnabled) {
                RDBMSBasedNotificationAgentImpl rDBMSBasedNotificationAgentImpl = new RDBMSBasedNotificationAgentImpl(contextStore);
                return var2_5;
            } else {
                HazelcastClusterNotificationListenerImpl hazelcastBasedListener = (HazelcastClusterNotificationListenerImpl)AndesContext.getInstance().getClusterNotificationListenerManager();
                if (null == hazelcastBasedListener) throw new AndesException("Cannot create HazelcastBasedNotificationAgentImpl. Create HazelcastClusterNotificationListenerImpl first to register Hazelcast topics");
                HazelcastBasedNotificationAgentImpl hazelcastBasedNotificationAgentImpl = new HazelcastBasedNotificationAgentImpl(hazelcastBasedListener.getClusterNotificationChannel(), hazelcastBasedListener.getDBSyncNotificationChannel());
            }
            return var2_5;
        } else {
            StandaloneMockNotificationAgent standaloneMockNotificationAgent = new StandaloneMockNotificationAgent();
        }
        return var2_5;
    }

    private void initConfiguration() {
        this.isRDBMSBasedCoordinationEnabled = (Boolean)AndesConfigurationManager.readValue(AndesConfiguration.CLUSTER_EVENT_SYNC_MODE_RDBMS_ENABLED);
        this.isClusteringEnabled = ClusterResourceHolder.getInstance().getClusterManager().isClusteringEnabled();
    }
}

