/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster.coordination;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesContextInformationManager;
import org.wso2.andes.kernel.ClusterNotificationListener;
import org.wso2.andes.kernel.disruptor.inbound.InboundBindingSyncEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundEventManager;
import org.wso2.andes.server.cluster.coordination.ClusterNotification;

public class BindingNotificationHandler
implements ClusterNotificationListener {
    private Log log = LogFactory.getLog(BindingNotificationHandler.class);
    private AndesContextInformationManager contextInformationManager;
    private InboundEventManager inboundEventManager;

    public BindingNotificationHandler(AndesContextInformationManager contextInformationManager, InboundEventManager inboundEventManager) {
        this.contextInformationManager = contextInformationManager;
        this.inboundEventManager = inboundEventManager;
    }

    @Override
    public void handleClusterNotification(ClusterNotification notification) {
        try {
            InboundBindingSyncEvent bindingSyncEvent = new InboundBindingSyncEvent(notification.getEncodedObjectAsString());
            ClusterNotificationListener.BindingChange changeType = ClusterNotificationListener.BindingChange.valueOf(notification.getChangeType());
            switch (changeType) {
                case Added: {
                    bindingSyncEvent.prepareForAddBindingEvent(this.contextInformationManager);
                    this.inboundEventManager.publishStateEvent(bindingSyncEvent);
                    break;
                }
                case Deleted: {
                    bindingSyncEvent.prepareForRemoveBinding(this.contextInformationManager);
                    this.inboundEventManager.publishStateEvent(bindingSyncEvent);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error while handling binding notification", (Throwable)e);
        }
    }
}

