/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.catalina.ha.session.DeltaRequest;
import org.apache.commons.lang.StringUtils;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.slot.SlotCoordinationConstants;
import org.wso2.andes.server.cluster.CoordinationConfigurableClusterAgent;
import org.wso2.andes.server.cluster.CoordinationStrategy;
import org.wso2.andes.server.cluster.CoordinatorInformation;
import org.wso2.andes.server.cluster.NodeDetail;
import org.wso2.andes.server.cluster.coordination.CoordinationConstants;

public class HazelcastCoordinationStrategy
implements CoordinationStrategy,
MembershipListener {
    private final HazelcastInstance hazelcastInstance;
    private String listenerRegistrationId;
    private CoordinationConfigurableClusterAgent configurableClusterAgent;
    private final AtomicBoolean isCoordinator = new AtomicBoolean(false);
    private IMap<String, String> coordinatorNodeDetailsMap;
    private IMap<String, String> thriftServerDetailsMap;

    public HazelcastCoordinationStrategy(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    @Override
    public void start(CoordinationConfigurableClusterAgent configurableClusterAgent, String nodeId, InetSocketAddress thriftAddress, InetSocketAddress hazelcastAddress) {
        this.thriftServerDetailsMap = this.hazelcastInstance.getMap(CoordinationConstants.THRIFT_SERVER_DETAILS_MAP_NAME);
        this.coordinatorNodeDetailsMap = this.hazelcastInstance.getMap(CoordinationConstants.COORDINATOR_NODE_DETAILS_MAP_NAME);
        this.listenerRegistrationId = this.hazelcastInstance.getCluster().addMembershipListener((MembershipListener)this);
        this.configurableClusterAgent = configurableClusterAgent;
        this.checkAndNotifyCoordinatorChange();
    }

    @Override
    public boolean isCoordinator() {
        Member oldestMember = (Member)this.hazelcastInstance.getCluster().getMembers().iterator().next();
        return oldestMember.localMember();
    }

    @Override
    public InetSocketAddress getThriftAddressOfCoordinator() {
        String hostname = (String)this.thriftServerDetailsMap.get((Object)SlotCoordinationConstants.THRIFT_COORDINATOR_SERVER_IP);
        String portString = (String)this.thriftServerDetailsMap.get((Object)SlotCoordinationConstants.THRIFT_COORDINATOR_SERVER_PORT);
        InetSocketAddress coordinatorAddress = null;
        if (null != hostname && null != portString) {
            int port = Integer.parseInt(portString);
            coordinatorAddress = new InetSocketAddress(hostname, port);
        }
        return coordinatorAddress;
    }

    @Override
    public List<String> getAllNodeIdentifiers() throws AndesException {
        Set members = this.hazelcastInstance.getCluster().getMembers();
        ArrayList<String> nodeIDList = new ArrayList<String>();
        for (Member member : members) {
            nodeIDList.add(this.configurableClusterAgent.getIdOfNode(member));
        }
        return nodeIDList;
    }

    @Override
    public List<NodeDetail> getAllNodeDetails() throws AndesException {
        ArrayList<NodeDetail> nodeDetails = new ArrayList<NodeDetail>();
        CoordinatorInformation coordinatorDetails = this.getCoordinatorDetails();
        InetSocketAddress coordinatorSocketAddress = new InetSocketAddress(coordinatorDetails.getHostname(), Integer.parseInt(coordinatorDetails.getPort()));
        for (Member member : this.hazelcastInstance.getCluster().getMembers()) {
            InetSocketAddress nodeSocketAddress = member.getSocketAddress();
            String nodeId = this.configurableClusterAgent.getIdOfNode(member);
            boolean isCoordinator = nodeSocketAddress.equals(coordinatorSocketAddress);
            nodeDetails.add(new NodeDetail(nodeId, nodeSocketAddress, isCoordinator));
        }
        return nodeDetails;
    }

    private CoordinatorInformation getCoordinatorDetails() {
        String ipAddress = (String)this.coordinatorNodeDetailsMap.get((Object)SlotCoordinationConstants.CLUSTER_COORDINATOR_SERVER_IP);
        String port = (String)this.coordinatorNodeDetailsMap.get((Object)SlotCoordinationConstants.CLUSTER_COORDINATOR_SERVER_PORT);
        return new CoordinatorInformation(ipAddress, port);
    }

    @Override
    public void stop() {
        this.hazelcastInstance.getCluster().removeMembershipListener(this.listenerRegistrationId);
    }

    public void memberAdded(MembershipEvent membershipEvent) {
        Member member = membershipEvent.getMember();
        DeltaRequest.log.info((Object)("Handling cluster gossip: New member joined to the cluster. Member Socket Address:" + member.getSocketAddress() + " UUID:" + member.getUuid()));
        this.checkAndNotifyCoordinatorChange();
        int maximumNumOfTries = 3;
        String nodeId = this.configurableClusterAgent.getIdOfNode(member);
        if (null == nodeId) {
            for (int numberOfAttemptsTried = 0; numberOfAttemptsTried < maximumNumOfTries; ++numberOfAttemptsTried) {
                try {
                    long sleepTime = Math.round(Math.pow(2.0, numberOfAttemptsTried));
                    TimeUnit.SECONDS.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                nodeId = this.configurableClusterAgent.getIdOfNode(member);
                if (StringUtils.isEmpty((String)nodeId)) continue;
            }
        }
        if (StringUtils.isEmpty((String)nodeId)) {
            DeltaRequest.log.warn((Object)("Node ID is not set for member " + member + " when newly joined"));
        }
        this.configurableClusterAgent.memberAdded(nodeId);
    }

    public void memberRemoved(MembershipEvent membershipEvent) {
        Member member = membershipEvent.getMember();
        DeltaRequest.log.info((Object)("Handling cluster gossip: A member left the cluster. Member Socket Address:" + member.getSocketAddress() + " UUID:" + member.getUuid()));
        try {
            this.checkAndNotifyCoordinatorChange();
            this.configurableClusterAgent.memberRemoved(this.configurableClusterAgent.getIdOfNode(member));
        }
        catch (AndesException e) {
            DeltaRequest.log.error((Object)("Error while handling node removal, " + member.getSocketAddress()), (Throwable)e);
        }
    }

    public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
    }

    private void checkAndNotifyCoordinatorChange() {
        if (this.isCoordinator() && this.isCoordinator.compareAndSet(false, true)) {
            this.updateThriftCoordinatorDetailsToMap();
            this.updateCoordinatorNodeDetailMap();
            this.configurableClusterAgent.becameCoordinator();
        } else {
            this.isCoordinator.set(false);
        }
    }

    private void updateCoordinatorNodeDetailMap() {
        Member localMember = this.hazelcastInstance.getCluster().getLocalMember();
        this.coordinatorNodeDetailsMap.put((Object)SlotCoordinationConstants.CLUSTER_COORDINATOR_SERVER_IP, (Object)localMember.getSocketAddress().getAddress().getHostAddress());
        this.coordinatorNodeDetailsMap.put((Object)SlotCoordinationConstants.CLUSTER_COORDINATOR_SERVER_PORT, (Object)Integer.toString(localMember.getSocketAddress().getPort()));
    }

    private void updateThriftCoordinatorDetailsToMap() {
        String thriftCoordinatorServerIP = AndesContext.getInstance().getThriftServerHost();
        int thriftCoordinatorServerPort = AndesContext.getInstance().getThriftServerPort();
        DeltaRequest.log.info((Object)("This node is elected as the Slot Coordinator. Registering " + thriftCoordinatorServerIP + ":" + thriftCoordinatorServerPort));
        this.thriftServerDetailsMap.put((Object)SlotCoordinationConstants.THRIFT_COORDINATOR_SERVER_IP, (Object)thriftCoordinatorServerIP);
        this.thriftServerDetailsMap.put((Object)SlotCoordinationConstants.THRIFT_COORDINATOR_SERVER_PORT, (Object)Integer.toString(thriftCoordinatorServerPort));
    }
}

