/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.Member;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.server.cluster.ClusterAgent;
import org.wso2.andes.server.cluster.ClusterManager;
import org.wso2.andes.server.cluster.CoordinationStrategy;
import org.wso2.andes.server.cluster.HazelcastCoordinationStrategy;
import org.wso2.andes.server.cluster.NodeDetail;
import org.wso2.andes.server.cluster.RDBMSCoordinationStrategy;
import org.wso2.andes.server.cluster.coordination.CoordinationConstants;
import org.wso2.andes.server.cluster.error.detection.DisabledNetworkPartitionDetector;
import org.wso2.andes.server.cluster.error.detection.HazelcastBasedNetworkPartitionDetector;
import org.wso2.andes.server.cluster.error.detection.NetworkPartitionDetector;
import org.wso2.andes.server.cluster.error.detection.NetworkPartitionListener;

public class CoordinationConfigurableClusterAgent
implements ClusterAgent {
    private static final Log log = LogFactory.getLog(CoordinationConfigurableClusterAgent.class);
    private final CoordinationStrategy coordinationStrategy;
    private final HazelcastInstance hazelcastInstance;
    private int uniqueIdOfLocalMember;
    private ClusterManager manager;
    private IMap<String, String> nodeIdMap;
    private NetworkPartitionDetector networkPartitionDetector;
    public static final int MAX_NODE_ID_READ_ATTEMPTS = 4;

    public CoordinationConfigurableClusterAgent(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
        this.nodeIdMap = hazelcastInstance.getMap(CoordinationConstants.NODE_ID_MAP_NAME);
        boolean isNetworkPartitionDectectionEnabled = (Boolean)AndesConfigurationManager.readValue(AndesConfiguration.RECOVERY_NETWORK_PARTITIONS_DETECTION);
        this.networkPartitionDetector = isNetworkPartitionDectectionEnabled ? new HazelcastBasedNetworkPartitionDetector(hazelcastInstance) : new DisabledNetworkPartitionDetector();
        boolean isRDBMBasedCoordinationEnabled = (Boolean)AndesConfigurationManager.readValue(AndesConfiguration.RDBMS_BASED_COORDINATION);
        this.coordinationStrategy = isRDBMBasedCoordinationEnabled ? new RDBMSCoordinationStrategy() : new HazelcastCoordinationStrategy(hazelcastInstance);
    }

    public void memberAdded(String nodeId) {
        this.manager.memberAdded(nodeId);
    }

    public void memberRemoved(String nodeId) throws AndesException {
        this.manager.memberRemoved(nodeId);
    }

    public void becameCoordinator() {
        this.manager.localNodeElectedAsCoordinator();
    }

    public String getIdOfNode(Member node) {
        String nodeId = (String)this.nodeIdMap.get((Object)node.getSocketAddress().toString());
        if (StringUtils.isEmpty((String)nodeId)) {
            return null;
        }
        return nodeId;
    }

    @Override
    public int getUniqueIdForLocalNode() {
        return this.uniqueIdOfLocalMember;
    }

    @Override
    public boolean isCoordinator() {
        return this.coordinationStrategy.isCoordinator();
    }

    @Override
    public InetSocketAddress getThriftAddressOfCoordinator() {
        return this.coordinationStrategy.getThriftAddressOfCoordinator();
    }

    @Override
    public void start(ClusterManager manager) throws AndesException {
        this.manager = manager;
        Member localMember = this.hazelcastInstance.getCluster().getLocalMember();
        this.nodeIdMap.set((Object)localMember.getSocketAddress().toString(), (Object)this.getLocalNodeIdentifier());
        this.checkForDuplicateNodeId(localMember);
        IdGenerator idGenerator = this.hazelcastInstance.getIdGenerator(CoordinationConstants.HAZELCAST_ID_GENERATOR_NAME);
        this.uniqueIdOfLocalMember = (int)idGenerator.newId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unique ID generation for message ID generation:" + this.uniqueIdOfLocalMember));
        }
        String thriftCoordinatorServerIP = AndesContext.getInstance().getThriftServerHost();
        int thriftCoordinatorServerPort = AndesContext.getInstance().getThriftServerPort();
        InetSocketAddress thriftAddress = new InetSocketAddress(thriftCoordinatorServerIP, thriftCoordinatorServerPort);
        InetSocketAddress hazelcastAddress = this.hazelcastInstance.getCluster().getLocalMember().getSocketAddress();
        this.coordinationStrategy.start(this, this.getLocalNodeIdentifier(), thriftAddress, hazelcastAddress);
        this.networkPartitionDetector.start();
    }

    private void checkForDuplicateNodeId(Member localMember) throws AndesException {
        Set members = this.hazelcastInstance.getCluster().getMembers();
        for (Member member : members) {
            String nodeIdOfMember = this.getIdOfNode(member);
            for (int nodeIdReadAttempts = 1; null == nodeIdOfMember && nodeIdReadAttempts <= 4; ++nodeIdReadAttempts) {
                long sleepTime = Math.round(Math.pow(2.0, nodeIdReadAttempts));
                log.warn((Object)("Node id was null for member " + member + ". Node id will be read again after " + sleepTime + " seconds."));
                try {
                    TimeUnit.SECONDS.sleep(sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                nodeIdOfMember = this.getIdOfNode(member);
            }
            if (nodeIdOfMember == null) {
                throw new AndesException("Failed to read Node id of hazelcast member " + member);
            }
            if (localMember == member || !nodeIdOfMember.equals(this.getLocalNodeIdentifier())) continue;
            throw new AndesException("Another node with the same node id: " + this.getLocalNodeIdentifier() + " found in the cluster. Cannot start the node.");
        }
    }

    @Override
    public void stop() {
        this.coordinationStrategy.stop();
    }

    @Override
    public String getLocalNodeIdentifier() {
        String nodeId = (String)AndesConfigurationManager.readValue(AndesConfiguration.COORDINATION_NODE_ID);
        if (AndesConfiguration.COORDINATION_NODE_ID.get().getDefaultValue().equals(nodeId)) {
            Member localMember = this.hazelcastInstance.getCluster().getLocalMember();
            nodeId = CoordinationConstants.NODE_NAME_PREFIX + localMember.getSocketAddress().getHostName() + CoordinationConstants.HOSTNAME_PORT_SEPARATOR + localMember.getSocketAddress().getPort();
        }
        return nodeId;
    }

    @Override
    public List<String> getAllNodeIdentifiers() throws AndesException {
        return this.coordinationStrategy.getAllNodeIdentifiers();
    }

    @Override
    public List<String> getAllClusterNodeAddresses() throws AndesException {
        ArrayList<String> nodeDetailStringList = new ArrayList<String>();
        List<NodeDetail> nodeDetails = this.coordinationStrategy.getAllNodeDetails();
        if (AndesContext.getInstance().isClusteringEnabled()) {
            for (NodeDetail nodeDetail : nodeDetails) {
                nodeDetailStringList.add(nodeDetail.getNodeId() + "," + nodeDetail.getClusterAgentAddress().getHostString() + "," + nodeDetail.getClusterAgentAddress().getPort() + "," + nodeDetail.isCoordinator());
            }
        }
        return nodeDetailStringList;
    }

    @Override
    public void addNetworkPartitionListener(int priority, NetworkPartitionListener listener) {
        this.networkPartitionDetector.addNetworkPartitionListener(priority, listener);
    }
}

