/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.Andes;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesContextStore;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.slot.SlotManagerClusterMode;
import org.wso2.andes.kernel.slot.SlotMessageCounter;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.cluster.ClusterAgent;
import org.wso2.andes.server.cluster.coordination.CoordinationConstants;
import org.wso2.andes.store.FailureObservingStoreManager;
import org.wso2.andes.store.HealthAwareStore;
import org.wso2.andes.store.StoreHealthListener;

public class ClusterManager
implements StoreHealthListener {
    private Log log = LogFactory.getLog(ClusterManager.class);
    private String nodeId;
    private AndesContextStore andesContextStore = AndesContext.getInstance().getAndesContextStore();
    private ClusterAgent clusterAgent;
    private boolean storeOperational;
    private ScheduledExecutorService slotRecoveryTaskService;
    public static final int SLOT_SUBMIT_TASK_POOL_SIZE = 1;

    public void init() throws AndesException {
        if (AndesContext.getInstance().isClusteringEnabled()) {
            this.initClusterMode();
            ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("SlotRecoveryOneTimeTask-%d").build();
            this.slotRecoveryTaskService = Executors.newScheduledThreadPool(1, namedThreadFactory);
        } else {
            this.initStandaloneMode();
        }
        this.storeOperational = true;
        FailureObservingStoreManager.registerStoreHealthListener(this);
    }

    public void memberAdded(String addedNodeId) {
        this.log.info((Object)("Handling cluster gossip: Node " + addedNodeId + "  Joined the Cluster"));
    }

    public void memberRemoved(String deletedNodeId) throws AndesException {
        this.log.info((Object)("Handling cluster gossip: Node " + deletedNodeId + "  left the Cluster"));
        if (this.clusterAgent.isCoordinator()) {
            SlotManagerClusterMode.getInstance().deletePublisherNode(deletedNodeId);
            SlotManagerClusterMode.getInstance().reassignSlotsWhenMemberLeaves(deletedNodeId);
            this.log.info((Object)"Scheduling slot recovery task.");
            this.slotRecoveryTaskService.schedule(new Runnable(){

                @Override
                public void run() {
                    Andes.getInstance().triggerRecoveryEvent();
                }
            }, (long)SlotMessageCounter.getInstance().SLOT_SUBMIT_TIMEOUT, TimeUnit.MILLISECONDS);
            ClusterResourceHolder.getInstance().getSubscriptionManager().removeAllSubscriptionsOfNodeFromMemoryAndStore(deletedNodeId);
        } else {
            ClusterResourceHolder.getInstance().getSubscriptionManager().removeAllSubscriptionsOfNodeFromMemory(deletedNodeId);
        }
    }

    public boolean isClusteringEnabled() {
        return AndesContext.getInstance().isClusteringEnabled();
    }

    public String getMyNodeID() {
        return this.nodeId;
    }

    public void prepareLocalNodeForShutDown() throws AndesException {
        this.clearAllPersistedStatesOfLocalNode();
    }

    public int getUniqueIdForLocalNode() {
        if (AndesContext.getInstance().isClusteringEnabled()) {
            return this.clusterAgent.getUniqueIdForLocalNode();
        }
        return 0;
    }

    private void initStandaloneMode() throws AndesException {
        try {
            this.nodeId = (String)AndesConfigurationManager.readValue(AndesConfiguration.COORDINATION_NODE_ID);
            if (AndesConfiguration.COORDINATION_NODE_ID.get().getDefaultValue().equals(this.nodeId)) {
                this.nodeId = CoordinationConstants.NODE_NAME_PREFIX + InetAddress.getLocalHost().toString();
            }
            ArrayList<String> nodeList = new ArrayList<String>(this.andesContextStore.getAllStoredNodeData().keySet());
            for (String node : nodeList) {
                this.andesContextStore.removeNodeData(node);
            }
            this.log.info((Object)("Initializing Standalone Mode. Current Node ID:" + this.nodeId + " " + InetAddress.getLocalHost().getHostAddress()));
            this.andesContextStore.storeNodeDetails(this.nodeId, InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            throw new AndesException("Unable to get the localhost address.", e);
        }
    }

    private void initClusterMode() throws AndesException {
        this.clusterAgent = AndesContext.getInstance().getClusterAgent();
        this.clusterAgent.start(this);
        this.nodeId = this.clusterAgent.getLocalNodeIdentifier();
        this.log.info((Object)("Initializing Cluster Mode. Current Node ID:" + this.nodeId));
        String localMemberHostAddress = this.clusterAgent.getLocalNodeIdentifier();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Stored node ID : " + this.nodeId + ". Stored node data(Hazelcast local member host address) : " + localMemberHostAddress));
        }
    }

    private void clearAllPersistedStatesOfDisappearedNode(String nodeID) throws AndesException {
        this.log.info((Object)("Clearing the Persisted State of Node with ID " + nodeID));
        this.andesContextStore.removeNodeData(nodeID);
        ClusterResourceHolder.getInstance().getSubscriptionManager().removeAllSubscriptionsOfNodeFromMemory(nodeID);
    }

    private void clearAllPersistedStatesOfLocalNode() throws AndesException {
        this.log.info((Object)("Clearing the Persisted State of Node with ID " + this.nodeId));
        this.andesContextStore.removeNodeData(this.nodeId);
        ClusterResourceHolder.getInstance().getSubscriptionManager().closeAllActiveLocalSubscriptions();
    }

    public void localNodeElectedAsCoordinator() {
    }

    public List<String> getAllClusterNodeAddresses() throws AndesException {
        if (AndesContext.getInstance().isClusteringEnabled()) {
            return this.clusterAgent.getAllClusterNodeAddresses();
        }
        ArrayList<String> nodes = new ArrayList<String>();
        nodes.add(this.getMyNodeID());
        return nodes;
    }

    public boolean getStoreHealth() {
        return this.storeOperational;
    }

    @Override
    public void storeNonOperational(HealthAwareStore store, Exception ex) {
        this.log.warn((Object)"Store became non-operational.");
        this.storeOperational = false;
    }

    @Override
    public void storeOperational(HealthAwareStore store) {
        this.storeOperational = true;
        this.log.info((Object)"Store became operational.");
    }
}

