/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster;

import java.util.List;
import javax.management.JMException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.management.common.mbeans.ClusterManagementInformation;
import org.wso2.andes.management.common.mbeans.annotations.MBeanConstructor;
import org.wso2.andes.server.cluster.ClusterManager;
import org.wso2.andes.server.management.AMQManagedObject;

public class ClusterManagementInformationMBean
extends AMQManagedObject
implements ClusterManagementInformation {
    private static final Log logger = LogFactory.getLog(ClusterManagementInformationMBean.class);
    private ClusterManager clusterManager;

    @MBeanConstructor(value="Creates an MBean exposing an Cluster Manager")
    public ClusterManagementInformationMBean(ClusterManager clusterManager) throws JMException {
        super(ClusterManagementInformation.class, "ClusterManagementInformation");
        this.clusterManager = clusterManager;
    }

    @Override
    public String getObjectInstanceName() {
        return "ClusterManagementInformation";
    }

    @Override
    public boolean isClusteringEnabled() {
        return AndesContext.getInstance().isClusteringEnabled();
    }

    @Override
    public String getMyNodeID() {
        return this.clusterManager.getMyNodeID();
    }

    @Override
    public List<String> getAllClusterNodeAddresses() throws JMException {
        try {
            return this.clusterManager.getAllClusterNodeAddresses();
        }
        catch (AndesException e) {
            logger.error((Object)"Error occurred while retrieving cluster details", (Throwable)e);
            throw new JMException("Error occurred while retrieving cluster details");
        }
    }

    @Override
    public boolean getStoreHealth() {
        return this.clusterManager.getStoreHealth();
    }
}

