/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.binding;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.AMQInternalException;
import org.wso2.andes.AMQSecurityException;
import org.wso2.andes.amqp.AMQPUtils;
import org.wso2.andes.amqp.QpidAndesBridge;
import org.wso2.andes.configuration.qpid.BindingConfig;
import org.wso2.andes.configuration.qpid.BindingConfigType;
import org.wso2.andes.configuration.qpid.ConfigStore;
import org.wso2.andes.configuration.qpid.ConfiguredObject;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.server.NameValidationUtils;
import org.wso2.andes.server.binding.Binding;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.exchange.TopicExchange;
import org.wso2.andes.server.logging.actors.CurrentActor;
import org.wso2.andes.server.logging.messages.BindingMessages;
import org.wso2.andes.server.logging.subjects.BindingLogSubject;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.store.DurableConfigurationStore;
import org.wso2.andes.server.virtualhost.VirtualHost;

public class BindingFactory {
    private final VirtualHost _virtualHost;
    private final DurableConfigurationStore.Source _configSource;
    private final Exchange _defaultExchange;
    private static final Logger _logger = Logger.getLogger(BindingFactory.class);
    private final ConcurrentHashMap<BindingImpl, BindingImpl> _bindings = new ConcurrentHashMap();

    public BindingFactory(VirtualHost vhost) {
        this(vhost, vhost.getExchangeRegistry().getDefaultExchange());
    }

    public BindingFactory(DurableConfigurationStore.Source configSource, Exchange defaultExchange) {
        this._configSource = configSource;
        this._defaultExchange = defaultExchange;
        this._virtualHost = configSource instanceof VirtualHost ? (VirtualHost)configSource : null;
    }

    public VirtualHost getVirtualHost() {
        return this._virtualHost;
    }

    public boolean addBinding(String bindingKey, AMQQueue queue, Exchange exchange, Map<String, Object> arguments) throws AMQSecurityException, AMQInternalException {
        boolean bindingAdded = this.makeBinding(bindingKey, queue, exchange, arguments, false, false);
        if (bindingAdded) {
            QpidAndesBridge.createBinding(exchange, new AMQShortString(bindingKey), queue);
        }
        return bindingAdded;
    }

    public boolean replaceBinding(String bindingKey, AMQQueue queue, Exchange exchange, Map<String, Object> arguments) throws AMQSecurityException, AMQInternalException {
        boolean isBindingAdded = this.makeBinding(bindingKey, queue, exchange, arguments, false, true);
        if (isBindingAdded) {
            QpidAndesBridge.createBinding(exchange, new AMQShortString(bindingKey), queue);
        }
        return isBindingAdded;
    }

    private synchronized boolean makeBinding(String bindingKey, AMQQueue queue, Exchange exchange, Map<String, Object> arguments, boolean restore, boolean force) throws AMQSecurityException, AMQInternalException {
        assert (queue != null);
        if (bindingKey == null) {
            bindingKey = "";
        }
        if (exchange == null) {
            exchange = this._defaultExchange;
        }
        if (arguments == null) {
            arguments = Collections.emptyMap();
        }
        if (exchange.getName().equalsIgnoreCase("amq.topic") && queue.isDurable() && this.checkIfQueueHasBoundToDifferentTopic(bindingKey, queue)) {
            throw new AMQInternalException("An Exclusive Bindings already exists for different topic. Not permitted.");
        }
        this.authoriseBind(bindingKey, queue, exchange);
        BindingImpl binding = new BindingImpl(bindingKey, queue, exchange, arguments);
        boolean isBindingExist = this._bindings.contains(binding);
        if (!isBindingExist || force) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("bindingKey: " + bindingKey + ", queue: " + queue + ", exchange: " + exchange));
            }
            if (exchange.getType() == TopicExchange.TYPE && !NameValidationUtils.isValidTopicName(bindingKey)) {
                this._virtualHost.getQueueRegistry().unregisterQueue(queue.getNameShortString());
                throw new AMQInternalException("\nTopic name: " + NameValidationUtils.getNameWithoutTenantDomain(bindingKey) + " can contain only alphanumeric characters and star(*) delimited by dots. Names can ends with any of these or, with '#' ");
            }
            if (binding.isDurable() && !restore) {
                this._configSource.getDurableConfigurationStore().bindQueue(exchange, new AMQShortString(bindingKey), queue, FieldTable.convertToFieldTable(arguments));
            }
            this._bindings.put(binding, binding);
            queue.addQueueDeleteTask(binding);
            exchange.addCloseTask(binding);
            queue.addBinding(binding);
            exchange.addBinding(binding);
            this.getConfigStore().addConfiguredObject(binding);
            binding.logCreation();
            return true;
        }
        return false;
    }

    public void authoriseBind(String bindingKey, AMQQueue queue, Exchange exchange) throws AMQSecurityException {
        if (!this.getVirtualHost().getSecurityManager().authoriseBind(exchange, queue, new AMQShortString(bindingKey))) {
            throw new AMQSecurityException("Permission denied: binding " + bindingKey);
        }
    }

    private boolean checkIfQueueHasBoundToDifferentTopic(String bindingKey, AMQQueue queue) {
        boolean isAlreadyABindingExistsForDifferentKey = false;
        List<Binding> bindingList = queue.getBindings();
        for (Binding b : bindingList) {
            if (!b.getExchange().getName().equals(AMQPUtils.TOPIC_EXCHANGE_NAME) || b.getBindingKey().equals(bindingKey)) continue;
            isAlreadyABindingExistsForDifferentKey = true;
            break;
        }
        return isAlreadyABindingExistsForDifferentKey;
    }

    private ConfigStore getConfigStore() {
        return this.getVirtualHost().getConfigStore();
    }

    public void restoreBinding(String bindingKey, AMQQueue queue, Exchange exchange, Map<String, Object> argumentMap) throws AMQSecurityException, AMQInternalException {
        this.makeBinding(bindingKey, queue, exchange, argumentMap, true, false);
    }

    public void removeBinding(Binding b) throws AMQSecurityException, AMQInternalException {
        this.removeBinding(b.getBindingKey(), b.getQueue(), b.getExchange(), b.getArguments(), true);
    }

    public void removeBinding(Binding b, boolean isLocal) throws AMQException {
        this.removeBinding(b.getBindingKey(), b.getQueue(), b.getExchange(), b.getArguments(), isLocal);
    }

    public synchronized Binding removeBinding(String bindingKey, AMQQueue queue, Exchange exchange, Map<String, Object> arguments, boolean isLocal) throws AMQSecurityException, AMQInternalException {
        assert (queue != null);
        if (bindingKey == null) {
            bindingKey = "";
        }
        if (exchange == null) {
            exchange = this._defaultExchange;
        }
        if (arguments == null) {
            arguments = Collections.emptyMap();
        }
        if (!this.getVirtualHost().getSecurityManager().authoriseUnbind(exchange, new AMQShortString(bindingKey), queue)) {
            throw new AMQSecurityException("Permission denied: binding " + bindingKey);
        }
        BindingImpl binding = this._bindings.remove(new BindingImpl(bindingKey, queue, exchange, arguments));
        try {
            if (binding != null) {
                if (binding.isDurable()) {
                    this._configSource.getDurableConfigurationStore().unbindQueue(exchange, new AMQShortString(bindingKey), queue, FieldTable.convertToFieldTable(arguments));
                }
                if (isLocal) {
                    QpidAndesBridge.removeBinding(binding);
                }
                exchange.removeBinding(binding);
                queue.removeBinding(binding);
                exchange.removeCloseTask(binding);
                queue.removeQueueDeleteTask(binding);
                binding.logDestruction();
                this.getConfigStore().removeConfiguredObject(binding);
            }
            return binding;
        }
        catch (AndesException e) {
            throw new AMQInternalException("Error while removing binding.", e);
        }
    }

    public Binding getBinding(String bindingKey, AMQQueue queue, Exchange exchange, Map<String, Object> arguments) {
        assert (queue != null);
        if (bindingKey == null) {
            bindingKey = "";
        }
        if (exchange == null) {
            exchange = this._defaultExchange;
        }
        if (arguments == null) {
            arguments = Collections.emptyMap();
        }
        BindingImpl b = new BindingImpl(bindingKey, queue, exchange, arguments);
        return this._bindings.get(b);
    }

    private final class BindingImpl
    extends Binding
    implements AMQQueue.Task,
    Exchange.Task,
    BindingConfig {
        private final BindingLogSubject _logSubject;
        private long _createTime;

        private BindingImpl(String bindingKey, AMQQueue queue, Exchange exchange, Map<String, Object> arguments) {
            super(queue.getVirtualHost().getConfigStore().createId(), bindingKey, queue, exchange, arguments);
            this._createTime = System.currentTimeMillis();
            this._logSubject = new BindingLogSubject(bindingKey, exchange, queue);
        }

        @Override
        public void doTask(AMQQueue queue) throws AMQException {
            BindingFactory.this.removeBinding(this);
        }

        @Override
        public void onClose(Exchange exchange) throws AMQSecurityException, AMQInternalException {
            BindingFactory.this.removeBinding(this);
        }

        void logCreation() {
            CurrentActor.get().message(this._logSubject, BindingMessages.CREATED(String.valueOf(this.getArguments()), this.getArguments() != null && !this.getArguments().isEmpty()));
        }

        void logDestruction() {
            CurrentActor.get().message(this._logSubject, BindingMessages.DELETED());
        }

        @Override
        public String getOrigin() {
            return (String)this.getArguments().get("qpid.fed.origin");
        }

        @Override
        public long getCreateTime() {
            return this._createTime;
        }

        @Override
        public BindingConfigType getConfigType() {
            return BindingConfigType.getInstance();
        }

        @Override
        public ConfiguredObject getParent() {
            return BindingFactory.this._virtualHost;
        }

        @Override
        public boolean isDurable() {
            return this.getQueue().isDurable() && this.getExchange().isDurable();
        }
    }
}

