/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.ack;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.wso2.andes.AMQException;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.configuration.util.TopicMessageDeliveryStrategy;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.ack.LimitedSizeQueueEntryHolder;
import org.wso2.andes.server.ack.UnacknowledgedMessageMap;
import org.wso2.andes.server.queue.QueueEntry;

public class UnacknowledgedMessageMapImpl
implements UnacknowledgedMessageMap {
    private final Object _lock = new Object();
    private long _unackedSize;
    private Map<Long, QueueEntry> _map;
    private long _lastDeliveryTag;
    private final int _prefetchLimit;

    public UnacknowledgedMessageMapImpl(int prefetchLimit, AMQChannel amqChannel, boolean isDurable) {
        this._prefetchLimit = prefetchLimit;
        TopicMessageDeliveryStrategy messageDeliveryStrategy = (TopicMessageDeliveryStrategy)((Object)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_TOPIC_MESSAGE_DELIVERY_STRATEGY));
        if (!isDurable && messageDeliveryStrategy.equals((Object)TopicMessageDeliveryStrategy.DISCARD_ALLOWED)) {
            int growLimit = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_ACK_HANDLING_MAX_UNACKED_MESSAGES);
            this._map = new LimitedSizeQueueEntryHolder(this._prefetchLimit, growLimit, amqChannel);
        } else {
            this._map = new LinkedHashMap<Long, QueueEntry>(prefetchLimit);
        }
    }

    @Override
    public void collect(long deliveryTag, boolean multiple, Map<Long, QueueEntry> msgs) {
        if (multiple) {
            this.collect(deliveryTag, msgs);
        } else {
            QueueEntry entry = this.get(deliveryTag);
            if (entry != null) {
                msgs.put(deliveryTag, entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Map<Long, QueueEntry> msgs) {
        Object object = this._lock;
        synchronized (object) {
            for (Long deliveryTag : msgs.keySet()) {
                this.remove(deliveryTag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueueEntry remove(long deliveryTag) {
        Object object = this._lock;
        synchronized (object) {
            QueueEntry message = this._map.remove(deliveryTag);
            if (message != null) {
                this._unackedSize -= message.getMessage().getSize();
            }
            return message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(UnacknowledgedMessageMap.Visitor visitor) throws AMQException {
        Object object = this._lock;
        synchronized (object) {
            Set<Map.Entry<Long, QueueEntry>> currentEntries = this._map.entrySet();
            for (Map.Entry<Long, QueueEntry> entry : currentEntries) {
                visitor.callback(entry.getKey(), entry.getValue());
            }
            visitor.visitComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(long deliveryTag, QueueEntry message) {
        Object object = this._lock;
        synchronized (object) {
            this._map.put(deliveryTag, message);
            this._unackedSize += message.getMessage().getSize();
            this._lastDeliveryTag = deliveryTag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<QueueEntry> cancelAllMessages() {
        Object object = this._lock;
        synchronized (object) {
            Collection<QueueEntry> currentEntries = this._map.values();
            this._map = new LinkedHashMap<Long, QueueEntry>(this._prefetchLimit);
            this._unackedSize = 0L;
            return currentEntries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this._lock;
        synchronized (object) {
            return this._map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this._lock;
        synchronized (object) {
            this._map.clear();
            this._unackedSize = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueueEntry get(long key) {
        Object object = this._lock;
        synchronized (object) {
            return this._map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Long> getDeliveryTags() {
        Object object = this._lock;
        synchronized (object) {
            return this._map.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collect(long key, Map<Long, QueueEntry> msgs) {
        Object object = this._lock;
        synchronized (object) {
            for (Map.Entry<Long, QueueEntry> entry : this._map.entrySet()) {
                msgs.put(entry.getKey(), entry.getValue());
                if (entry.getKey() != key) continue;
                break;
            }
        }
    }
}

