/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.ack;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.amqp.QpidAndesBridge;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.queue.QueueEntry;

public class LimitedSizeQueueEntryHolder
extends LinkedHashMap<Long, QueueEntry> {
    protected static final Logger _logger = Logger.getLogger(LimitedSizeQueueEntryHolder.class);
    private int growLimit;
    private AMQChannel amqChannel;

    public LimitedSizeQueueEntryHolder(int initialCapacity, int growLimit, AMQChannel amqChannel) {
        super(initialCapacity);
        this.growLimit = growLimit;
        this.amqChannel = amqChannel;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<Long, QueueEntry> eldest) {
        if (this.size() > this.growLimit && eldest.getValue().isTimelyDisposable()) {
            QueueEntry eldestQueueEntry = eldest.getValue();
            eldestQueueEntry.getMessage().getArrivalTime();
            _logger.warn((Object)("Simulating Acknowledgement and removing queue entry id= " + eldestQueueEntry.getMessage().getMessageNumber() + " as it is growing"));
            this.simulateAcknowledgement(eldestQueueEntry);
            return true;
        }
        return false;
    }

    private void simulateAcknowledgement(QueueEntry queueEntry) {
        try {
            QpidAndesBridge.ackReceived(this.amqChannel.getId(), queueEntry.getMessage().getMessageNumber());
        }
        catch (AMQException e) {
            _logger.error((Object)("Error while simulating acknowledgement for message id= " + queueEntry.getMessage().getMessageNumber()), (Throwable)e);
        }
    }
}

