/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;

public class NameValidationUtils {
    private static Boolean isStrictValidationEnabled = (Boolean)AndesConfigurationManager.readValue(AndesConfiguration.ALLOW_STRICT_NAME_VALIDATION);
    private static Pattern topicNamePattern = isStrictValidationEnabled != false ? Pattern.compile("^(((\\*|\\w+)\\.)*(\\*|\\w+|#))$") : Pattern.compile("^(((\\*|(\\w|:)+)\\.)*(\\*|(\\w|:)+|#))$");
    private static final Pattern queueNamePattern = Pattern.compile("[[a-zA-Z]+[^(\\x00-\\x80)]+[0-9_\\-#*:.?&()]+]+");

    public static boolean isValidQueueName(String queueNameWithTenantDomain) {
        String queueName = NameValidationUtils.getNameWithoutTenantDomain(queueNameWithTenantDomain);
        Matcher nameMatcher = queueNamePattern.matcher(queueName);
        return nameMatcher.matches();
    }

    public static boolean isValidTopicName(String topicNameWithTenantDomain) {
        String topicName = NameValidationUtils.getNameWithoutTenantDomain(topicNameWithTenantDomain);
        Matcher nameMatcher = topicNamePattern.matcher(topicName);
        return nameMatcher.matches();
    }

    public static boolean isValidUITopicName(String topicName) {
        Matcher topicNameMatcher = topicNamePattern.matcher(topicName);
        return topicNameMatcher.matches();
    }

    public static String getNameWithoutTenantDomain(String nameWithTenantDomain) {
        String nameWithoutTenantDomain = nameWithTenantDomain;
        if (nameWithTenantDomain.contains("/")) {
            nameWithoutTenantDomain = nameWithTenantDomain.substring(nameWithTenantDomain.indexOf("/") + 1);
        }
        return nameWithoutTenantDomain;
    }
}

