/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.dna.mqtt.moquette.server.Server;
import org.wso2.andes.server.Broker;
import org.wso2.andes.server.BrokerOptions;
import org.wso2.andes.server.ProtocolExclusion;
import org.wso2.andes.server.registry.ApplicationRegistry;

public class Main {
    private final Options options = new Options();
    private CommandLine commandLine;
    private static final Logger logger = Logger.getLogger(Main.class);

    public static void main(String[] args) {
        if (System.getProperty("log4j.configuration") == null) {
            System.setProperty("log4j.defaultInitOverride", "true");
        }
        new Main(args);
    }

    public Main(String[] args) {
        this.setOptions(this.options);
        if (this.parseCommandline(args)) {
            try {
                this.execute();
            }
            catch (Exception e) {
                logger.error((Object)"Exception during startup. Triggering shutdown ", (Throwable)e);
                this.shutdown(1);
            }
        }
    }

    protected boolean parseCommandline(String[] args) {
        try {
            this.commandLine = new PosixParser().parse(this.options, args);
            return true;
        }
        catch (ParseException e) {
            logger.error((Object)"Error while parsing command line arguments ", (Throwable)e);
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("Qpid", this.options, true);
            return false;
        }
    }

    protected void setOptions(Options options) {
        Option help = new Option("h", "help", false, "print this message");
        Option version = new Option("v", "version", false, "print the version information and exit");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given configuration file");
        OptionBuilder.withLongOpt((String)"config");
        Option configFile = OptionBuilder.create((String)"c");
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"listen on the specified port. Overrides any value in the config file");
        OptionBuilder.withLongOpt((String)"port");
        Option port = OptionBuilder.create((String)"p");
        OptionBuilder.withArgName((String)"exclude-0-10");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"when listening on the specified port do not accept AMQP0-10 connections. The specified port must be one specified on the command line");
        OptionBuilder.withLongOpt((String)"exclude-0-10");
        Option exclude0_10 = OptionBuilder.create();
        OptionBuilder.withArgName((String)"exclude-0-9-1");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"when listening on the specified port do not accept AMQP0-9-1 connections. The specified port must be one specified on the command line");
        OptionBuilder.withLongOpt((String)"exclude-0-9-1");
        Option exclude0_9_1 = OptionBuilder.create();
        OptionBuilder.withArgName((String)"exclude-0-9");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"when listening on the specified port do not accept AMQP0-9 connections. The specified port must be one specified on the command line");
        OptionBuilder.withLongOpt((String)"exclude-0-9");
        Option exclude0_9 = OptionBuilder.create();
        OptionBuilder.withArgName((String)"exclude-0-8");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"when listening on the specified port do not accept AMQP0-8 connections. The specified port must be one specified on the command line");
        OptionBuilder.withLongOpt((String)"exclude-0-8");
        Option exclude0_8 = OptionBuilder.create();
        OptionBuilder.withArgName((String)"mport");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"listen on the specified management port. Overrides any value in the config file");
        OptionBuilder.withLongOpt((String)"mport");
        Option mport = OptionBuilder.create((String)"m");
        OptionBuilder.withArgName((String)"bind");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"bind to the specified address. Overrides any value in the config file");
        OptionBuilder.withLongOpt((String)"bind");
        Option bind = OptionBuilder.create((String)"b");
        OptionBuilder.withArgName((String)"logconfig");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use the specified log4j xml configuration file. By default looks for a file named etc/log4j.xml in the same directory as the configuration file");
        OptionBuilder.withLongOpt((String)"logconfig");
        Option logconfig = OptionBuilder.create((String)"l");
        OptionBuilder.withArgName((String)"logwatch");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"monitor the log file configuration file for changes. Units are seconds. Zero means do not check for changes.");
        OptionBuilder.withLongOpt((String)"logwatch");
        Option logwatchconfig = OptionBuilder.create((String)"w");
        OptionBuilder.withArgName((String)"sslport");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"SSL port. Overrides any value in the config file");
        OptionBuilder.withLongOpt((String)"sslport");
        Option sslport = OptionBuilder.create((String)"s");
        OptionBuilder.withArgName((String)"mqttport");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"MQTT port. Overrides any value in the config file");
        OptionBuilder.withLongOpt((String)"mqttport");
        Option mqttPort = OptionBuilder.create((String)"q");
        options.addOption(help);
        options.addOption(version);
        options.addOption(configFile);
        options.addOption(logconfig);
        options.addOption(logwatchconfig);
        options.addOption(port);
        options.addOption(exclude0_10);
        options.addOption(exclude0_9_1);
        options.addOption(exclude0_9);
        options.addOption(exclude0_8);
        options.addOption(mport);
        options.addOption(bind);
        options.addOption(sslport);
        options.addOption(mqttPort);
    }

    protected void execute() throws Exception {
        String mqttPortStr;
        Object[] sslPortStr;
        Object[] portStr;
        String bindAddr;
        String jmxPort;
        String logConfig;
        String logWatchConfig;
        BrokerOptions options = new BrokerOptions();
        String configFile = this.commandLine.getOptionValue("c");
        if (configFile != null) {
            options.setConfigFile(configFile);
        }
        if ((logWatchConfig = this.commandLine.getOptionValue("w")) != null) {
            options.setLogWatchFrequency(Integer.parseInt(logWatchConfig));
        }
        if ((logConfig = this.commandLine.getOptionValue("l")) != null) {
            options.setLogConfigFile(logConfig);
        }
        if ((jmxPort = this.commandLine.getOptionValue("m")) != null) {
            options.setJmxPort(Integer.parseInt(jmxPort));
        }
        if ((bindAddr = this.commandLine.getOptionValue("b")) != null) {
            options.setBind(bindAddr);
        }
        if ((portStr = this.commandLine.getOptionValues("p")) != null) {
            Main.parsePortArray(options, portStr, false);
            for (ProtocolExclusion pe : ProtocolExclusion.values()) {
                Main.parsePortArray(options, (Object[])this.commandLine.getOptionValues(pe.getExcludeName()), pe);
            }
        }
        if ((sslPortStr = this.commandLine.getOptionValues("s")) != null) {
            Main.parsePortArray(options, sslPortStr, true);
            for (ProtocolExclusion pe : ProtocolExclusion.values()) {
                Main.parsePortArray(options, (Object[])this.commandLine.getOptionValues(pe.getExcludeName()), pe);
            }
        }
        if ((mqttPortStr = this.commandLine.getOptionValue("q")) != null) {
            Main.parseMQTTPort(options, mqttPortStr);
        } else {
            options.setMQTTPort(1833);
        }
        this.startBroker(options);
    }

    protected void startMQTTBroker(BrokerOptions options) throws Exception {
        Server server = new Server();
        server.startServer(options.getMQTTPort());
    }

    protected void startBroker(BrokerOptions options) throws Exception {
        Broker broker = new Broker();
        broker.startup(options);
        this.startMQTTBroker(options);
    }

    protected void shutdown(int status) {
        ApplicationRegistry.remove();
        System.exit(status);
    }

    private static void parsePortArray(BrokerOptions options, Object[] ports, boolean ssl) throws Broker.InitException {
        if (ports != null) {
            for (Object port : ports) {
                try {
                    if (ssl) {
                        options.addSSLPort(Integer.parseInt(String.valueOf(port)));
                        continue;
                    }
                    options.addPort(Integer.parseInt(String.valueOf(port)));
                }
                catch (NumberFormatException e) {
                    throw new Broker.InitException("Invalid port: " + port, e);
                }
            }
        }
    }

    private static void parseMQTTPort(BrokerOptions options, String port) throws Broker.InitException {
        if (port != null) {
            try {
                options.setMQTTPort(Integer.parseInt(String.valueOf(port)));
            }
            catch (NumberFormatException e) {
                throw new Broker.InitException("Invalid port: " + port, e);
            }
        }
    }

    private static void parsePortArray(BrokerOptions options, Object[] ports, ProtocolExclusion excludedProtocol) throws Broker.InitException {
        if (ports != null) {
            for (Object port : ports) {
                try {
                    options.addExcludedPort(excludedProtocol, Integer.parseInt(String.valueOf(port)));
                }
                catch (NumberFormatException e) {
                    throw new Broker.InitException("Invalid port for exclusion: " + port, e);
                }
            }
        }
    }
}

