/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server;

import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.server.ack.UnacknowledgedMessageMap;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.store.TransactionLog;
import org.wso2.andes.server.txn.AutoCommitTransaction;
import org.wso2.andes.server.txn.ServerTransaction;

public class ExtractResendAndRequeue
implements UnacknowledgedMessageMap.Visitor {
    private static final Logger _log = Logger.getLogger(ExtractResendAndRequeue.class);
    private final Map<Long, QueueEntry> _msgToRequeue;
    private final Map<Long, QueueEntry> _msgToResend;
    private final boolean _requeueIfUnabletoResend;
    private final UnacknowledgedMessageMap _unacknowledgedMessageMap;
    private final TransactionLog _transactionLog;

    public ExtractResendAndRequeue(UnacknowledgedMessageMap unacknowledgedMessageMap, Map<Long, QueueEntry> msgToRequeue, Map<Long, QueueEntry> msgToResend, boolean requeueIfUnabletoResend, TransactionLog txnLog) {
        this._unacknowledgedMessageMap = unacknowledgedMessageMap;
        this._msgToRequeue = msgToRequeue;
        this._msgToResend = msgToResend;
        this._requeueIfUnabletoResend = requeueIfUnabletoResend;
        this._transactionLog = txnLog;
    }

    @Override
    public boolean callback(long deliveryTag, QueueEntry message) throws AMQException {
        message.setRedelivered();
        this._msgToRequeue.put(deliveryTag, message);
        return false;
    }

    private void dequeueEntry(QueueEntry node) {
        AutoCommitTransaction txn = new AutoCommitTransaction(this._transactionLog);
        this.dequeueEntry(node, txn);
    }

    private void dequeueEntry(final QueueEntry node, ServerTransaction txn) {
        txn.dequeue(node.getQueue(), node.getMessage(), new ServerTransaction.Action(){

            @Override
            public void postCommit() {
                node.discard();
            }

            @Override
            public void onRollback() {
            }
        });
    }

    @Override
    public void visitComplete() {
        this._unacknowledgedMessageMap.clear();
    }
}

