/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server;

import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.JMException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.AMQException;
import org.wso2.andes.amqp.AMQPUtils;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.configuration.modules.JKSStore;
import org.wso2.andes.configuration.qpid.ServerConfiguration;
import org.wso2.andes.configuration.qpid.ServerNetworkTransportConfiguration;
import org.wso2.andes.configuration.qpid.management.ConfigurationManagementMBean;
import org.wso2.andes.kernel.Andes;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesKernelBoot;
import org.wso2.andes.server.BrokerOptions;
import org.wso2.andes.server.ProtocolExclusion;
import org.wso2.andes.server.information.management.ServerInformationMBean;
import org.wso2.andes.server.logging.SystemOutMessageLogger;
import org.wso2.andes.server.logging.actors.BrokerActor;
import org.wso2.andes.server.logging.actors.CurrentActor;
import org.wso2.andes.server.logging.actors.GenericActor;
import org.wso2.andes.server.logging.messages.BrokerMessages;
import org.wso2.andes.server.protocol.AMQProtocolEngineFactory;
import org.wso2.andes.server.protocol.AmqpProtocolVersion;
import org.wso2.andes.server.protocol.MultiVersionProtocolEngineFactory;
import org.wso2.andes.server.registry.ApplicationRegistry;
import org.wso2.andes.server.registry.ConfigurationFileApplicationRegistry;
import org.wso2.andes.server.transport.QpidAcceptor;
import org.wso2.andes.ssl.SSLContextFactory;
import org.wso2.andes.transport.network.IncomingNetworkTransport;
import org.wso2.andes.transport.network.Transport;
import org.wso2.andes.transport.network.mina.MinaNetworkTransport;

public class Broker {
    private static Log log = LogFactory.getLog(Broker.class);

    public void shutdown() throws AndesException {
        Andes.getInstance().shutDown();
    }

    public void startup() throws AndesException {
        this.startup(new BrokerOptions());
    }

    public void startup(BrokerOptions options) throws AndesException {
        CurrentActor.set(new BrokerActor(new SystemOutMessageLogger()));
        this.startupImpl(options);
        CurrentActor.remove();
    }

    private void startAMQPListener(ApplicationRegistry config, BrokerOptions options, ServerConfiguration serverConfig) throws AndesException {
        try {
            if (((Boolean)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_AMQP_ENABLED)).booleanValue()) {
                String bindAddressFromBrokerOptions;
                HashSet<Integer> exclude_0_8;
                HashSet<Integer> exclude_0_9;
                HashSet<Integer> exclude_0_9_1;
                HashSet<Integer> exclude_0_10;
                HashSet<Integer> sslPorts;
                ConfigurationManagementMBean configMBean = new ConfigurationManagementMBean();
                configMBean.register();
                ServerInformationMBean sysInfoMBean = new ServerInformationMBean(config);
                sysInfoMBean.register();
                HashSet<Integer> ports = new HashSet<Integer>(options.getPorts());
                if (ports.isEmpty()) {
                    Broker.parsePortList(ports, serverConfig.getPorts());
                }
                if ((sslPorts = new HashSet<Integer>(options.getSSLPorts())).isEmpty()) {
                    Broker.parsePortList(sslPorts, serverConfig.getSSLPorts());
                }
                if ((exclude_0_10 = new HashSet<Integer>(options.getExcludedPorts(ProtocolExclusion.v0_10))).isEmpty()) {
                    Broker.parsePortList(exclude_0_10, serverConfig.getPortExclude010());
                }
                if ((exclude_0_9_1 = new HashSet<Integer>(options.getExcludedPorts(ProtocolExclusion.v0_9_1))).isEmpty()) {
                    Broker.parsePortList(exclude_0_9_1, serverConfig.getPortExclude091());
                }
                if ((exclude_0_9 = new HashSet<Integer>(options.getExcludedPorts(ProtocolExclusion.v0_9))).isEmpty()) {
                    Broker.parsePortList(exclude_0_9, serverConfig.getPortExclude09());
                }
                if ((exclude_0_8 = new HashSet<Integer>(options.getExcludedPorts(ProtocolExclusion.v0_8))).isEmpty()) {
                    Broker.parsePortList(exclude_0_8, serverConfig.getPortExclude08());
                }
                if (null == (bindAddressFromBrokerOptions = options.getBind())) {
                    bindAddressFromBrokerOptions = serverConfig.getBind();
                }
                InetAddress bindAddressForHostname = "*".equals(bindAddressFromBrokerOptions) ? new InetSocketAddress(0).getAddress() : InetAddress.getByName(bindAddressFromBrokerOptions);
                String hostName = bindAddressForHostname.getCanonicalHostName();
                if (!serverConfig.getSSLOnly()) {
                    Iterator iterator = ports.iterator();
                    while (iterator.hasNext()) {
                        int port = (Integer)iterator.next();
                        EnumSet<AmqpProtocolVersion> supported = EnumSet.allOf(AmqpProtocolVersion.class);
                        if (exclude_0_10.contains(port)) {
                            supported.remove((Object)AmqpProtocolVersion.v0_10);
                        }
                        if (exclude_0_9_1.contains(port)) {
                            supported.remove((Object)AmqpProtocolVersion.v0_9_1);
                        }
                        if (exclude_0_9.contains(port)) {
                            supported.remove((Object)AmqpProtocolVersion.v0_9);
                        }
                        if (exclude_0_8.contains(port)) {
                            supported.remove((Object)AmqpProtocolVersion.v0_8);
                        }
                        ServerNetworkTransportConfiguration settings = new ServerNetworkTransportConfiguration(serverConfig, port, bindAddressFromBrokerOptions, "tcp");
                        IncomingNetworkTransport transport = Transport.getIncomingTransportInstance();
                        MultiVersionProtocolEngineFactory protocolEngineFactory = new MultiVersionProtocolEngineFactory(hostName, supported);
                        transport.accept(settings, protocolEngineFactory, null);
                        ApplicationRegistry.getInstance().addAcceptor(new InetSocketAddress(bindAddressForHostname, port), new QpidAcceptor(transport, "TCP"));
                        CurrentActor.get().message(BrokerMessages.LISTENING("TCP", port));
                    }
                }
                if (serverConfig.getEnableSSL()) {
                    JKSStore keyStore = (JKSStore)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_AMQP_SSL_CONNECTION_KEYSTORE);
                    JKSStore trustStore = (JKSStore)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_AMQP_SSL_CONNECTION_TRUSTSTORE);
                    String sslProtocols = (String)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_AMQP_SSL_CONNECTION_PROTOCOLS);
                    String ciphers = (String)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_AMQP_SSL_CONNECTION_CIPHERS);
                    SSLContextFactory sslFactory = new SSLContextFactory(trustStore.getStoreLocation(), trustStore.getPassword(), trustStore.getStoreAlgorithm(), keyStore.getStoreLocation(), keyStore.getPassword(), keyStore.getStoreAlgorithm(), sslProtocols, ciphers);
                    Iterator iterator = sslPorts.iterator();
                    while (iterator.hasNext()) {
                        int sslPort = (Integer)iterator.next();
                        ServerNetworkTransportConfiguration settings = new ServerNetworkTransportConfiguration(serverConfig, sslPort, bindAddressFromBrokerOptions, "tcp");
                        MinaNetworkTransport transport = new MinaNetworkTransport();
                        transport.accept(settings, new AMQProtocolEngineFactory(), sslFactory);
                        ApplicationRegistry.getInstance().addAcceptor(new InetSocketAddress(bindAddressForHostname, sslPort), new QpidAcceptor(transport, "TCP"));
                        CurrentActor.get().message(BrokerMessages.LISTENING("TCP/SSL", sslPort));
                    }
                }
                CurrentActor.get().message(BrokerMessages.READY());
            } else {
                log.warn((Object)"AMQP Transport is disabled as per configuration.");
            }
        }
        catch (JMException e) {
            throw new AndesException("Unable to register an MBean", e);
        }
        catch (UnknownHostException e) {
            throw new AndesException("Unable to get bind address", e);
        }
    }

    private void startupImpl(BrokerOptions options) throws AndesException {
        boolean isActorSet = false;
        try {
            String qpidHome = options.getQpidHome();
            File configFile = this.getConfigFile(options.getConfigFile(), "qpid-config.xml", qpidHome, true);
            log.info((Object)("Starting Qpid using configuration : " + configFile.getAbsolutePath()));
            ConfigurationFileApplicationRegistry config = new ConfigurationFileApplicationRegistry(configFile);
            ServerConfiguration serverConfig = config.getConfiguration();
            this.updateManagementPort(serverConfig, options.getJmxPort());
            ApplicationRegistry.initialise(config);
            BrokerMessages.reload();
            CurrentActor.set(new BrokerActor(config.getCompositeStartupMessageLogger()));
            CurrentActor.setDefault(new BrokerActor(config.getRootMessageLogger()));
            GenericActor.setDefaultMessageLogger(config.getRootMessageLogger());
            isActorSet = true;
            AndesKernelBoot.initializeComponents();
            this.startAMQPListener(config, options, serverConfig);
            AndesKernelBoot.startMessaging();
            AndesKernelBoot.createSuperTenantDLC();
            AMQPUtils.DEFAULT_CONTENT_CHUNK_SIZE = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_MAX_CONTENT_CHUNK_SIZE);
        }
        catch (ConfigurationException ce) {
            throw new AndesException("Unable to create configuration files based application registry", (Throwable)((Object)ce));
        }
        catch (AMQException amqe) {
            throw new AndesException("Unable to register a memory configuration", amqe);
        }
        catch (Exception e) {
            throw new AndesException("Unable to initialise application registry", e);
        }
        finally {
            if (isActorSet) {
                CurrentActor.remove();
            }
        }
    }

    private File getConfigFile(String fileName, String defaultFileName, String qpidHome, boolean throwOnFileNotFound) throws InitException {
        File configFile = null != fileName ? new File(fileName) : new File(qpidHome, defaultFileName);
        if (!configFile.exists() && throwOnFileNotFound) {
            String error = "File " + fileName + " could not be found. Check the file exists and is readable.";
            if (null == qpidHome) {
                error = error + "\nNote: " + "ANDES_HOME" + " is not set.";
            }
            throw new InitException(error, null);
        }
        return configFile;
    }

    public static void parsePortList(Set<Integer> output, List<?> ports) throws InitException {
        if (null != ports) {
            for (Object port : ports) {
                try {
                    output.add(Integer.parseInt(String.valueOf(port)));
                }
                catch (NumberFormatException e) {
                    throw new InitException("Invalid port: " + port, e);
                }
            }
        }
    }

    private void updateManagementPort(ServerConfiguration configuration, Integer managementPort) {
        if (null != managementPort) {
            try {
                configuration.setJMXManagementPort(managementPort);
            }
            catch (NumberFormatException e) {
                throw new InitException("Invalid management port: " + managementPort, null);
            }
        }
    }

    protected static class InitException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        InitException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

