/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import javax.transaction.xa.Xid;
import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.AMQInternalException;
import org.wso2.andes.AMQSecurityException;
import org.wso2.andes.amqp.AMQPUtils;
import org.wso2.andes.amqp.QpidAndesBridge;
import org.wso2.andes.configuration.qpid.ConfigStore;
import org.wso2.andes.configuration.qpid.ConfiguredObject;
import org.wso2.andes.configuration.qpid.ConnectionConfig;
import org.wso2.andes.configuration.qpid.SessionConfig;
import org.wso2.andes.configuration.qpid.SessionConfigType;
import org.wso2.andes.exchange.ExchangeDefaults;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.BasicContentHeaderProperties;
import org.wso2.andes.framing.ChannelFlowBody;
import org.wso2.andes.framing.ContentBody;
import org.wso2.andes.framing.ContentHeaderBody;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.framing.MethodRegistry;
import org.wso2.andes.framing.abstraction.ContentChunk;
import org.wso2.andes.framing.abstraction.MessagePublishInfo;
import org.wso2.andes.kernel.Andes;
import org.wso2.andes.kernel.AndesChannel;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.FlowControlListener;
import org.wso2.andes.kernel.disruptor.DisruptorEventCallback;
import org.wso2.andes.kernel.disruptor.inbound.InboundTransactionEvent;
import org.wso2.andes.kernel.dtx.AlreadyKnownDtxException;
import org.wso2.andes.kernel.dtx.JoinAndResumeDtxException;
import org.wso2.andes.kernel.dtx.NotAssociatedDtxException;
import org.wso2.andes.kernel.dtx.SuspendAndFailDtxException;
import org.wso2.andes.kernel.dtx.UnknownDtxBranchException;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.ExtractResendAndRequeue;
import org.wso2.andes.server.ack.UnacknowledgedMessageMap;
import org.wso2.andes.server.ack.UnacknowledgedMessageMapImpl;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.flow.FlowCreditManager;
import org.wso2.andes.server.flow.Pre0_10CreditManager;
import org.wso2.andes.server.logging.LogActor;
import org.wso2.andes.server.logging.LogSubject;
import org.wso2.andes.server.logging.actors.AMQPChannelActor;
import org.wso2.andes.server.logging.actors.CurrentActor;
import org.wso2.andes.server.logging.messages.ChannelMessages;
import org.wso2.andes.server.logging.subjects.ChannelLogSubject;
import org.wso2.andes.server.message.AMQMessage;
import org.wso2.andes.server.message.MessageMetaData;
import org.wso2.andes.server.message.MessageReference;
import org.wso2.andes.server.message.ServerMessage;
import org.wso2.andes.server.output.ProtocolOutputConverter;
import org.wso2.andes.server.protocol.AMQConnectionModel;
import org.wso2.andes.server.protocol.AMQProtocolEngine;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.protocol.AMQSessionModel;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.BaseQueue;
import org.wso2.andes.server.queue.DLCQueueUtils;
import org.wso2.andes.server.queue.IncomingMessage;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.registry.ApplicationRegistry;
import org.wso2.andes.server.store.MessageStore;
import org.wso2.andes.server.store.StorableMessageMetaData;
import org.wso2.andes.server.store.StoredMessage;
import org.wso2.andes.server.subscription.ClientDeliveryMethod;
import org.wso2.andes.server.subscription.RecordDeliveryMethod;
import org.wso2.andes.server.subscription.Subscription;
import org.wso2.andes.server.subscription.SubscriptionFactoryImpl;
import org.wso2.andes.server.txn.AutoCommitTransaction;
import org.wso2.andes.server.txn.DtxNotSelectedException;
import org.wso2.andes.server.txn.IncorrectDtxStateException;
import org.wso2.andes.server.txn.LocalTransaction;
import org.wso2.andes.server.txn.QpidDistributedTransaction;
import org.wso2.andes.server.txn.RollbackOnlyDtxException;
import org.wso2.andes.server.txn.ServerTransaction;
import org.wso2.andes.server.txn.TimeoutDtxException;
import org.wso2.andes.server.virtualhost.AMQChannelMBean;
import org.wso2.andes.server.virtualhost.VirtualHost;
import org.wso2.andes.store.StoredAMQPMessage;
import org.wso2.andes.tools.utils.MessageTracer;

public class AMQChannel
implements SessionConfig,
AMQSessionModel {
    public static final int DEFAULT_PREFETCH = 5000;
    private static final Logger _logger = Logger.getLogger(AMQChannel.class);
    private static final boolean MSG_AUTH = ApplicationRegistry.getInstance().getConfiguration().getMsgAuth();
    private final int _channelId;
    private final Pre0_10CreditManager _creditManager = new Pre0_10CreditManager(0L, 0L);
    private final AndesChannel andesChannel;
    private AtomicLong _deliveryTag = new AtomicLong(0L);
    private AMQQueue _defaultQueue;
    private AtomicInteger _consumerTag = new AtomicInteger(0);
    private IncomingMessage _currentMessage;
    protected final Map<AMQShortString, Subscription> _tag2SubscriptionMap = new HashMap<AMQShortString, Subscription>();
    private final MessageStore _messageStore;
    private UnacknowledgedMessageMap _unacknowledgedMessageMap = new UnacknowledgedMessageMapImpl(5000, this, false);
    private SortedSet<QueueEntry> _acknowledgedMessages = new TreeSet<QueueEntry>();
    private final AtomicBoolean _suspended = new AtomicBoolean(false);
    private ServerTransaction _transaction;
    private InboundTransactionEvent andesTransactionEvent;
    private boolean beginPublisherTransaction;
    private final AtomicLong _txnStarts = new AtomicLong(0L);
    private final AtomicLong _txnCommits = new AtomicLong(0L);
    private final AtomicLong _txnRejects = new AtomicLong(0L);
    private final AtomicLong _txnCount = new AtomicLong(0L);
    private final AtomicLong _txnUpdateTime = new AtomicLong(0L);
    private final AMQProtocolSession _session;
    private AtomicBoolean _closing = new AtomicBoolean(false);
    private final ConcurrentMap<AMQQueue, Boolean> _blockingQueues = new ConcurrentHashMap<AMQQueue, Boolean>();
    private final AtomicBoolean _blocking = new AtomicBoolean(false);
    private long lastRejectedMessageId = -1L;
    private long lastRollbackedMessageId = -1L;
    private LogActor _actor;
    private LogSubject _logSubject;
    private volatile boolean _rollingBack;
    private static final Runnable NULL_TASK = new Runnable(){

        @Override
        public void run() {
        }
    };
    private List<QueueEntry> _resendList = new ArrayList<QueueEntry>();
    private static final AMQShortString IMMEDIATE_DELIVERY_REPLY_TEXT = new AMQShortString("Immediate delivery is not possible.");
    private final UUID _id;
    private long _createTime = System.currentTimeMillis();
    private AMQChannelMBean _managedObject;
    private final String id = "(" + System.identityHashCode(this) + ")";
    public boolean isMessagesAcksProcessing = false;
    private final ClientDeliveryMethod _clientDeliveryMethod = new ClientDeliveryMethod(){

        @Override
        public void deliverToClient(Subscription sub, QueueEntry entry, long deliveryTag) throws AMQException {
            AMQChannel.this.getProtocolSession().getProtocolOutputConverter().writeDeliver(entry, AMQChannel.this.getChannelId(), deliveryTag, sub.getConsumerTag());
            AMQChannel.this._session.registerMessageDelivered(entry.getMessage().getSize());
        }
    };
    private final RecordDeliveryMethod _recordDeliveryMethod = new RecordDeliveryMethod(){

        @Override
        public void recordMessageDelivery(Subscription sub, QueueEntry entry, long deliveryTag) {
            AMQChannel.this.addUnacknowledgedMessage(entry, deliveryTag, sub);
        }
    };

    public AMQChannel(AMQProtocolSession session, int channelId, MessageStore messageStore) throws AMQException {
        this._session = session;
        this._channelId = channelId;
        this._actor = new AMQPChannelActor(this, session.getLogActor().getRootMessageLogger());
        this._logSubject = new ChannelLogSubject(this);
        this._id = UUID.randomUUID();
        this._actor.message(ChannelMessages.CREATE());
        this.beginPublisherTransaction = false;
        String andesChannelId = AMQPUtils.DEFAULT_ANDES_CHANNEL_IDENTIFIER;
        if (null != ((AMQProtocolEngine)this._session).getAddress()) {
            andesChannelId = ((AMQProtocolEngine)this._session).getAddress().substring(1);
        }
        FlowControlListener flowControlListener = new FlowControlListener(){

            @Override
            public void block() {
                if (!AMQChannel.this.isSubscriptionChannel()) {
                    AMQChannel.this.blockChannel();
                }
            }

            @Override
            public void unblock() {
                if (!AMQChannel.this.isSubscriptionChannel()) {
                    AMQChannel.this.unblockChannel();
                }
            }

            @Override
            public void disconnect() {
                try {
                    AMQChannel.this.mgmtClose();
                }
                catch (AMQException e) {
                    _logger.error((Object)("error occured while trying to disconnect channel. Id: " + AMQChannel.this._channelId), (Throwable)e);
                }
            }
        };
        try {
            this.andesChannel = Andes.getInstance().createChannel(andesChannelId, flowControlListener);
        }
        catch (Exception ex) {
            throw new AMQInternalException("unable to create channel due to internal server error", ex);
        }
        this.getConfigStore().addConfiguredObject(this);
        this._messageStore = messageStore;
        this._transaction = new AutoCommitTransaction(this._messageStore);
        try {
            this._managedObject = new AMQChannelMBean(this);
            this._managedObject.register();
        }
        catch (JMException e) {
            _logger.error((Object)"Error in creating AMQChannelMBean", (Throwable)e);
        }
    }

    public ConfigStore getConfigStore() {
        return this.getVirtualHost().getConfigStore();
    }

    public void resendRecoveredMessages(DisruptorEventCallback recoverOKCallback) {
        try {
            this._unacknowledgedMessageMap.clear();
            QpidAndesBridge.recoverMessagesOfChannel(this, recoverOKCallback);
        }
        catch (AMQException e) {
            _logger.error((Object)"Error while resending recovered messages.", (Throwable)e);
        }
    }

    public void setLocalTransactional() throws AMQException {
        this._transaction = new LocalTransaction(this._messageStore);
        this._txnStarts.incrementAndGet();
        this.beginPublisherTransaction = true;
    }

    public void setDtxTransactional() throws AndesException {
        this._transaction = new QpidDistributedTransaction(this.andesChannel, this.getId());
    }

    @Override
    public boolean isTransactional() {
        return !(this._transaction instanceof AutoCommitTransaction);
    }

    public boolean inTransaction() {
        return this.isTransactional() && this._txnUpdateTime.get() > 0L && this._transaction.getTransactionStartTime() > 0L;
    }

    private void incrementOutstandingTxnsIfNecessary() {
        if (this.isTransactional()) {
            this._txnCount.compareAndSet(0L, 1L);
        }
    }

    private void decrementOutstandingTxnsIfNecessary() {
        if (this.isTransactional()) {
            this._txnCount.compareAndSet(1L, 0L);
        }
    }

    @Override
    public Long getTxnStarts() {
        return this._txnStarts.get();
    }

    @Override
    public Long getTxnCommits() {
        return this._txnCommits.get();
    }

    @Override
    public Long getTxnRejects() {
        return this._txnRejects.get();
    }

    @Override
    public Long getTxnCount() {
        return this._txnCount.get();
    }

    public int getChannelId() {
        return this._channelId;
    }

    public void setPublishFrame(MessagePublishInfo info, Exchange exchange) throws AMQSecurityException {
        if (!this.getVirtualHost().getSecurityManager().authorisePublish(info.isImmediate(), info.getRoutingKey().asString(), exchange.getName()) || DLCQueueUtils.isDeadLetterQueue(info.getRoutingKey().asString())) {
            throw new AMQSecurityException("Permission denied: " + exchange.getName());
        }
        this._currentMessage = new IncomingMessage(info);
        this._currentMessage.setExchange(exchange);
    }

    public void publishContentHeader(ContentHeaderBody contentHeaderBody) throws AMQException {
        if (this._currentMessage == null) {
            throw new AMQException("Received content header without previously receiving a BasicPublish frame");
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Content header received on channel " + this._channelId));
        }
        this._currentMessage.setContentHeaderBody(contentHeaderBody);
        this._currentMessage.setPublisherSessionID(this._session.getSessionID());
        this._currentMessage.setExpiration();
        this._currentMessage.setArrivalTime();
        MessageMetaData mmd = this._currentMessage.headersReceived();
        mmd.set_clientIP(this._session.toString().substring(0, this._session.toString().indexOf(58)));
        StoredMessage<MessageMetaData> handle = this.addAMQPMessage(mmd);
        if (handle instanceof StoredAMQPMessage) {
            ((StoredAMQPMessage)handle).setChannelID(this.getId().toString());
        }
        this._currentMessage.setStoredMessage(handle);
        this.routeCurrentMessage();
        this.deliverCurrentMessageIfComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverCurrentMessageIfComplete() throws AMQException {
        block17: {
            if (this._currentMessage.allContentReceived()) {
                try {
                    ArrayList<? extends BaseQueue> destinationQueues = this._currentMessage.getDestinationQueues();
                    if (!this.checkMessageUserId(this._currentMessage.getContentHeader())) {
                        this._transaction.addPostTransactionAction(new WriteReturnAction(AMQConstant.ACCESS_REFUSED, "Access Refused", this._currentMessage));
                        this.failIfDistributedTransaction("Access Refused for message - " + this.createAMQMessage(this._currentMessage));
                        break block17;
                    }
                    if (null == this.andesChannel.getDestination()) {
                        this.andesChannel.setDestination(this._currentMessage.getRoutingKey());
                    }
                    if ((null == destinationQueues || destinationQueues.isEmpty()) && ExchangeDefaults.DIRECT_EXCHANGE_NAME.equals(this._currentMessage.getExchange())) {
                        if (this._currentMessage.isMandatory() || this._currentMessage.isImmediate()) {
                            this._transaction.addPostTransactionAction(new WriteReturnAction(AMQConstant.NO_ROUTE, "No Route for message", this._currentMessage));
                            this.failIfDistributedTransaction("No routes for message - " + this.createAMQMessage(this._currentMessage));
                            _logger.warn((Object)("MESSAGE DISCARDED: No routes for message - " + this.createAMQMessage(this._currentMessage)));
                        } else {
                            _logger.warn((Object)("MESSAGE DISCARDED: No routes for message - " + this.createAMQMessage(this._currentMessage)));
                        }
                        break block17;
                    }
                    IncomingMessage incomingMessage = this._currentMessage;
                    if (this.isAttachedToADistributedTransaction()) {
                        if (MessageTracer.isEnabled()) {
                            MessageTracer.trace(incomingMessage.getRoutingKey(), this.getId(), this.andesChannel.getIdentifier(), "dtx message received to AMQChannel");
                        }
                        ((QpidDistributedTransaction)this._transaction).enqueueMessage(incomingMessage, this.andesChannel);
                        break block17;
                    }
                    try {
                        if (this.beginPublisherTransaction) {
                            this.andesTransactionEvent = Andes.getInstance().newTransaction(this.andesChannel);
                            this.beginPublisherTransaction = false;
                        }
                        if (_logger.isDebugEnabled()) {
                            _logger.debug((Object)("Message id " + incomingMessage.getMessageNumber() + " received from channel " + this.getId()));
                        }
                        if (MessageTracer.isEnabled()) {
                            MessageTracer.trace(incomingMessage.getRoutingKey(), this.getId(), this.andesChannel.getIdentifier(), " message received to AMQChannel");
                        }
                        QpidAndesBridge.messageReceived(incomingMessage, this.andesChannel, this.andesTransactionEvent);
                    }
                    catch (Throwable e) {
                        _logger.error((Object)("Error processing completed messages, Close the session " + this.getSessionName()), e);
                        if (this._session instanceof AMQProtocolEngine) {
                            ((AMQProtocolEngine)this._session).closeProtocolSession();
                        }
                    }
                }
                finally {
                    long bodySize = this._currentMessage.getSize();
                    long timestamp = ((BasicContentHeaderProperties)this._currentMessage.getContentHeader().getProperties()).getTimestamp();
                    this._session.registerMessageReceived(bodySize, timestamp);
                    this._currentMessage = null;
                }
            }
        }
    }

    private void failIfDistributedTransaction(String reason) {
        if (this.isAttachedToADistributedTransaction()) {
            ((QpidDistributedTransaction)this._transaction).failTransaction(reason);
        }
    }

    private boolean isAttachedToALocalTransaction() {
        return this._transaction instanceof LocalTransaction;
    }

    private boolean isAttachedToADistributedTransaction() {
        return this._transaction instanceof QpidDistributedTransaction;
    }

    public void publishContentBody(ContentBody contentBody) throws AMQException {
        if (this._currentMessage == null) {
            throw new AMQException("Received content body without previously receiving a JmsPublishBody");
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)(this.debugIdentity() + "Content body received on channel " + this._channelId));
        }
        try {
            ContentChunk contentChunk = this._session.getMethodRegistry().getProtocolVersionMethodConverter().convertToContentChunk(contentBody);
            this._currentMessage.addContentBodyFrame(contentChunk);
            this.deliverCurrentMessageIfComplete();
        }
        catch (AMQException e) {
            this._currentMessage = null;
            throw e;
        }
    }

    protected void routeCurrentMessage() throws AMQException {
        this._currentMessage.route();
    }

    public long getNextDeliveryTag() {
        return this._deliveryTag.incrementAndGet();
    }

    public long getCurrentDeliveryTag() {
        return this._deliveryTag.get();
    }

    public int getNextConsumerTag() {
        return this._consumerTag.incrementAndGet();
    }

    public Subscription getSubscription(AMQShortString subscription) {
        return this._tag2SubscriptionMap.get(subscription);
    }

    public AMQShortString subscribeToQueue(AMQShortString tag, AMQQueue queue, boolean acks, FieldTable filters, boolean noLocal, boolean exclusive, Runnable sendConsumeOk) throws AMQException {
        if (this._tag2SubscriptionMap.size() > 0) {
            throw new AMQException("Creating multiple consumers per channel is not allowed by Andes");
        }
        this._unacknowledgedMessageMap = new UnacknowledgedMessageMapImpl(5000, this, queue.isDurable());
        Subscription subscription = SubscriptionFactoryImpl.INSTANCE.createSubscription(this._channelId, this._session, tag, acks, filters, noLocal, this._creditManager);
        try {
            queue.registerSubscription(subscription, exclusive);
            try {
                QpidAndesBridge.createAMQPSubscription(subscription, queue, sendConsumeOk);
            }
            catch (AMQException e) {
                queue.unregisterSubscription(subscription);
                throw e;
            }
        }
        catch (AMQException e) {
            this._tag2SubscriptionMap.remove(tag);
            throw e;
        }
        this._tag2SubscriptionMap.put(tag, subscription);
        return tag;
    }

    public boolean isSubscriptionChannel() {
        return this._tag2SubscriptionMap.size() > 0;
    }

    public boolean unsubscribeConsumer(AMQShortString consumerTag) throws AMQException {
        Subscription sub = this._tag2SubscriptionMap.remove(consumerTag);
        if (sub != null) {
            try {
                sub.getSendLock();
                sub.getQueue().unregisterSubscription(sub);
            }
            finally {
                sub.releaseSendLock();
            }
            return true;
        }
        _logger.warn((Object)("Attempt to unsubscribe consumer with tag '" + consumerTag + "' which is not registered."));
        return false;
    }

    @Override
    public void close() throws AMQException {
        if (!this._closing.compareAndSet(false, true)) {
            _logger.debug((Object)("Channel " + this._channelId + " is already closing. Hence dropping close request."));
            return;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Closing channel with channel ID " + this._channelId));
        }
        try {
            CurrentActor.get().message(this._logSubject, ChannelMessages.CLOSE());
            this.unsubscribeAllConsumers();
            if (this.isAttachedToALocalTransaction()) {
                this._transaction.rollback();
            }
            if (this.isAttachedToADistributedTransaction()) {
                ((QpidDistributedTransaction)this._transaction).close(this.getId());
            }
            if (null != this.andesTransactionEvent) {
                this.andesTransactionEvent.close();
            }
            try {
                this.requeue();
            }
            catch (AMQException e) {
                _logger.error((Object)("Caught AMQException whilst attempting to reque:" + e));
            }
            this.getConfigStore().removeConfiguredObject(this);
            this.forgetMessages4Channel();
            if (this._managedObject != null) {
                this._managedObject.unregister();
            }
        }
        catch (AndesException e) {
            throw new AMQException("Exception occurred while closing channel " + this._channelId, e);
        }
        finally {
            Andes.getInstance().deleteChannel(this.andesChannel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsubscribeAllConsumers() throws AMQException {
        if (_logger.isInfoEnabled()) {
            if (!this._tag2SubscriptionMap.isEmpty()) {
                _logger.info((Object)("Unsubscribing all consumers on channel " + this.toString()));
            } else {
                _logger.info((Object)("No consumers to unsubscribe on channel " + this.toString()));
            }
        }
        for (Map.Entry<AMQShortString, Subscription> me : this._tag2SubscriptionMap.entrySet()) {
            if (_logger.isInfoEnabled()) {
                _logger.info((Object)("Unsubscribing consumer '" + me.getKey() + "' on channel " + this.toString()));
            }
            Subscription sub = me.getValue();
            try {
                sub.getSendLock();
                sub.getQueue().unregisterSubscription(sub);
            }
            finally {
                sub.releaseSendLock();
            }
        }
        this._tag2SubscriptionMap.clear();
    }

    public void addUnacknowledgedMessage(QueueEntry entry, long deliveryTag, Subscription subscription) {
        if (_logger.isDebugEnabled()) {
            if (entry.getQueue() == null) {
                _logger.debug((Object)("Adding unacked message with a null queue:" + entry));
            } else if (_logger.isDebugEnabled()) {
                _logger.debug((Object)(this.debugIdentity() + " Adding unacked message(" + entry.getMessage().toString() + " DT:" + deliveryTag + ") with a queue(" + entry.getQueue() + ") for " + subscription));
            }
        }
        this._unacknowledgedMessageMap.add(deliveryTag, entry);
    }

    public String debugIdentity() {
        return this._channelId + this.id;
    }

    public void requeue() throws AMQException {
        Collection<QueueEntry> messagesToBeDelivered = this._unacknowledgedMessageMap.cancelAllMessages();
        if (!messagesToBeDelivered.isEmpty() && _logger.isInfoEnabled()) {
            _logger.info((Object)("Requeuing " + messagesToBeDelivered.size() + " unacked messages. for " + this.toString()));
        }
        for (QueueEntry unacked : messagesToBeDelivered) {
            if (!unacked.isQueueDeleted()) {
                unacked.setRedelivered();
                unacked.release();
                continue;
            }
            unacked.discard();
        }
    }

    public void requeue(long deliveryTag) throws AMQException {
        QueueEntry unacked = this._unacknowledgedMessageMap.remove(deliveryTag);
        if (unacked != null) {
            unacked.setRedelivered();
            if (!unacked.isQueueDeleted()) {
                unacked.release();
            } else {
                _logger.warn((Object)(System.identityHashCode(this) + " Requested requeue of message(" + unacked + "):" + deliveryTag + " but no queue defined and no DeadLetter queue so DROPPING message."));
                unacked.discard();
            }
        } else {
            _logger.warn((Object)("Requested requeue of message:" + deliveryTag + " but no such delivery tag exists." + this._unacknowledgedMessageMap.size()));
        }
    }

    public Map<Long, QueueEntry> recoverMessages(boolean requeue) throws AMQException {
        long deliveryTag;
        QueueEntry message;
        LinkedHashMap<Long, QueueEntry> msgToRequeue = new LinkedHashMap<Long, QueueEntry>();
        LinkedHashMap<Long, QueueEntry> msgToResend = new LinkedHashMap<Long, QueueEntry>();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("unacked map Size:" + this._unacknowledgedMessageMap.size()));
        }
        this._unacknowledgedMessageMap.visit(new ExtractResendAndRequeue(this._unacknowledgedMessageMap, msgToRequeue, msgToResend, requeue, this._messageStore));
        if (_logger.isDebugEnabled()) {
            if (!msgToResend.isEmpty()) {
                _logger.debug((Object)("Preparing (" + msgToResend.size() + ") message to resend."));
            } else {
                _logger.debug((Object)"No message to resend.");
            }
        }
        for (Map.Entry entry : msgToResend.entrySet()) {
            message = (QueueEntry)entry.getValue();
            deliveryTag = (Long)entry.getKey();
            ServerMessage msg = message.getMessage();
            AMQQueue queue = message.getQueue();
            message.setRedelivered();
            Subscription sub = message.getDeliveredSubscription();
            if (sub != null) {
                if (queue.resend(message, sub)) continue;
                msgToRequeue.put(deliveryTag, message);
                continue;
            }
            if (_logger.isInfoEnabled()) {
                _logger.info((Object)("DeliveredSubscription not recorded so just requeueing(" + message.toString() + ")to prevent loss"));
            }
            msgToRequeue.put(deliveryTag, message);
        }
        if (_logger.isInfoEnabled() && !msgToRequeue.isEmpty()) {
            _logger.info((Object)("Preparing (" + msgToRequeue.size() + ") message to requeue to."));
        }
        for (Map.Entry entry : msgToRequeue.entrySet()) {
            message = (QueueEntry)entry.getValue();
            deliveryTag = (Long)entry.getKey();
            this._unacknowledgedMessageMap.remove(deliveryTag);
            message.setRedelivered();
            message.release();
        }
        return msgToRequeue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeMessage(long deliveryTag, boolean multiple) throws AMQException {
        try {
            this.isMessagesAcksProcessing = true;
            Collection<QueueEntry> ackedMessages = this.getAckedMessages(deliveryTag, multiple);
            if (this._transaction instanceof QpidDistributedTransaction) {
                this._transaction.dequeue(this.getId(), ackedMessages, (ServerTransaction.Action)new MessageAcknowledgeAction(ackedMessages));
            } else {
                for (QueueEntry entry : ackedMessages) {
                    QpidAndesBridge.ackReceived(this.getId(), entry.getMessage().getMessageNumber());
                }
            }
            if (MessageTracer.isEnabled()) {
                for (QueueEntry queueEntry : ackedMessages) {
                    MessageTracer.trace(queueEntry.getMessage().getRoutingKey(), this.getId(), this.andesChannel.getIdentifier(), this.isAttachedToADistributedTransaction(), deliveryTag, multiple, "acknowledgment received to AMQChannel");
                }
            }
            this.updateTransactionalActivity();
        }
        finally {
            this.isMessagesAcksProcessing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<QueueEntry> getAckedMessages(long deliveryTag, boolean multiple) {
        LinkedHashMap<Long, QueueEntry> ackedMessageMap = new LinkedHashMap<Long, QueueEntry>();
        UnacknowledgedMessageMap unacknowledgedMessageMap = this._unacknowledgedMessageMap;
        synchronized (unacknowledgedMessageMap) {
            this._unacknowledgedMessageMap.collect(deliveryTag, multiple, ackedMessageMap);
            this._unacknowledgedMessageMap.remove(ackedMessageMap);
        }
        return ackedMessageMap.values();
    }

    public UnacknowledgedMessageMap getUnacknowledgedMessageMap() {
        return this._unacknowledgedMessageMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSuspended(boolean suspended) {
        boolean wasSuspended = this._suspended.getAndSet(suspended);
        if (wasSuspended != suspended) {
            if (!suspended) {
                this._actor.message(this._logSubject, ChannelMessages.FLOW("Started"));
            }
            if (wasSuspended) {
                for (Subscription s : this._tag2SubscriptionMap.values()) {
                    s.getQueue().deliverAsync(s);
                }
            }
            if (!wasSuspended) {
                for (Subscription s : this._tag2SubscriptionMap.values()) {
                    try {
                        s.getSendLock();
                    }
                    finally {
                        s.releaseSendLock();
                    }
                }
            }
            if (suspended) {
                this._actor.message(this._logSubject, ChannelMessages.FLOW("Stopped"));
            }
        }
    }

    public boolean isSuspended() {
        return this._suspended.get() || this._closing.get() || this._session.isClosing();
    }

    public void commit() throws AMQException {
        if (!this.isTransactional()) {
            throw new AMQException("Fatal error: commit called on non-transactional channel");
        }
        this._transaction.commit();
        if (null != this.andesTransactionEvent) {
            try {
                this.andesTransactionEvent.commit();
            }
            catch (AndesException e) {
                throw new AMQException(AMQConstant.INTERNAL_ERROR, "Error occurred while committing transaction.", e);
            }
        }
        this._txnCommits.incrementAndGet();
        this._txnStarts.incrementAndGet();
        this.decrementOutstandingTxnsIfNecessary();
    }

    public void rollback() throws AMQException {
        this.rollback(NULL_TASK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Runnable postRollbackTask) throws AMQException {
        if (!this.isTransactional()) {
            throw new AMQException("Fatal error: commit called on non-transactional channel");
        }
        this._rollingBack = true;
        boolean requiresSuspend = this._suspended.compareAndSet(false, true);
        for (Subscription sub : this._tag2SubscriptionMap.values()) {
            sub.getSendLock();
            sub.releaseSendLock();
        }
        if (null != this.andesTransactionEvent) {
            try {
                this.andesTransactionEvent.rollback();
            }
            catch (AndesException e) {
                throw new AMQException(AMQConstant.INTERNAL_ERROR, "Error occurred while rollback ", e);
            }
        }
        try {
            this._transaction.rollback();
        }
        finally {
            this._rollingBack = false;
            this._txnRejects.incrementAndGet();
            this._txnStarts.incrementAndGet();
            this.decrementOutstandingTxnsIfNecessary();
        }
        postRollbackTask.run();
        for (QueueEntry entry : this._resendList) {
            Subscription sub = entry.getDeliveredSubscription();
            if (sub == null || sub.isClosed()) {
                entry.release();
                continue;
            }
            sub.getQueue().resend(entry, sub);
        }
        this._resendList.clear();
        if (requiresSuspend) {
            this._suspended.set(false);
            for (Subscription sub : this._tag2SubscriptionMap.values()) {
                sub.getQueue().deliverAsync(sub);
            }
        }
    }

    private void updateTransactionalActivity() {
        if (this.isTransactional()) {
            this._txnUpdateTime.set(System.currentTimeMillis());
        }
    }

    public String toString() {
        return "[" + this._session.toString() + ":" + this._channelId + "]";
    }

    public void setDefaultQueue(AMQQueue queue) {
        this._defaultQueue = queue;
    }

    public AMQQueue getDefaultQueue() {
        return this._defaultQueue;
    }

    public boolean isClosing() {
        return this._closing.get();
    }

    public AMQProtocolSession getProtocolSession() {
        return this._session;
    }

    public FlowCreditManager getCreditManager() {
        return this._creditManager;
    }

    public void setCredit(long prefetchSize, int prefetchCount) {
        this._actor.message(ChannelMessages.PREFETCH_SIZE(prefetchSize, prefetchCount));
        this._creditManager.setCreditLimits(prefetchSize, prefetchCount);
    }

    public MessageStore getMessageStore() {
        return this._messageStore;
    }

    public ClientDeliveryMethod getClientDeliveryMethod() {
        return this._clientDeliveryMethod;
    }

    public RecordDeliveryMethod getRecordDeliveryMethod() {
        return this._recordDeliveryMethod;
    }

    private AMQMessage createAMQMessage(IncomingMessage incomingMessage) throws AMQException {
        AMQMessage message = new AMQMessage(incomingMessage.getStoredMessage());
        message.setExpiration(incomingMessage.getExpiration());
        message.setClientIdentifier(this._session);
        message.setPublisherSessionID(this._session.getSessionID());
        return message;
    }

    private boolean checkMessageUserId(ContentHeaderBody header) {
        AMQShortString userID;
        AMQShortString aMQShortString = userID = header.getProperties() instanceof BasicContentHeaderProperties ? ((BasicContentHeaderProperties)header.getProperties()).getUserId() : null;
        return !MSG_AUTH || this._session.getAuthorizedPrincipal().getName().equals(userID == null ? "" : userID.toString());
    }

    @Override
    public Object getID() {
        return this._channelId;
    }

    @Override
    public AMQConnectionModel getConnectionModel() {
        return this._session;
    }

    @Override
    public String getClientID() {
        return String.valueOf(this._session.getContextKey());
    }

    @Override
    public LogSubject getLogSubject() {
        return this._logSubject;
    }

    public void startDtxTransaction(Xid xid, boolean join, boolean resume) throws DtxNotSelectedException, JoinAndResumeDtxException, UnknownDtxBranchException, AlreadyKnownDtxException, AndesException {
        QpidDistributedTransaction distributedTransaction = this.assertDtxTransaction();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Starting distributed transaction with GID : " + Arrays.toString(xid.getGlobalTransactionId())));
        }
        MessageTracer.trace(xid, this.getId(), "dtx.start received to AMQChannel");
        distributedTransaction.start(this.getId(), xid, join, resume);
    }

    public void endDtxTransaction(Xid xid, boolean fail, boolean suspend) throws DtxNotSelectedException, UnknownDtxBranchException, SuspendAndFailDtxException, NotAssociatedDtxException, TimeoutDtxException, AndesException {
        QpidDistributedTransaction distributedTransaction = this.assertDtxTransaction();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Ending distributed transaction with GID : " + Arrays.toString(xid.getGlobalTransactionId())));
        }
        MessageTracer.trace(xid, this.getId(), "dtx.end received to AMQChannel");
        distributedTransaction.end(this.getId(), xid, fail, suspend);
    }

    public void prepareDtxTransaction(Xid xid, DisruptorEventCallback callback) throws DtxNotSelectedException, TimeoutDtxException, UnknownDtxBranchException, IncorrectDtxStateException, AndesException, RollbackOnlyDtxException {
        QpidDistributedTransaction distributedTransaction = this.assertDtxTransaction();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Preparing distributed transaction with GID : " + Arrays.toString(xid.getGlobalTransactionId())));
        }
        MessageTracer.trace(xid, this.getId(), "dtx.prepare received to AMQChannel");
        distributedTransaction.prepare(xid, callback);
    }

    public void commitDtxTransaction(Xid xid, boolean onePhase, DisruptorEventCallback callback) throws DtxNotSelectedException, UnknownDtxBranchException, IncorrectDtxStateException, AndesException, RollbackOnlyDtxException, TimeoutDtxException {
        QpidDistributedTransaction distributedTransaction = this.assertDtxTransaction();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Committing distributed transaction with GID : " + Arrays.toString(xid.getGlobalTransactionId())));
        }
        MessageTracer.trace(xid, this.getId(), "dtx.commit received to AMQChannel");
        distributedTransaction.commit(xid, onePhase, callback);
    }

    public void rollbackDtxTransaction(Xid xid, DisruptorEventCallback callback) throws DtxNotSelectedException, UnknownDtxBranchException, AndesException, TimeoutDtxException, IncorrectDtxStateException {
        QpidDistributedTransaction distributedTransaction = this.assertDtxTransaction();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Rolling back distributed transaction with GID : " + Arrays.toString(xid.getGlobalTransactionId())));
        }
        MessageTracer.trace(xid, this.getId(), "dtx.rollback received to AMQChannel");
        distributedTransaction.rollback(xid, callback);
    }

    public void forgetDtxTransaction(Xid xid) throws DtxNotSelectedException, UnknownDtxBranchException, IncorrectDtxStateException, AndesException {
        QpidDistributedTransaction distributedTransaction = this.assertDtxTransaction();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Forgetting the distributed transaction with GID : " + Arrays.toString(xid.getGlobalTransactionId())));
        }
        distributedTransaction.forget(xid);
        MessageTracer.trace(xid, this.getId(), "dtx.forget received to AMQChannel");
    }

    public void setDtxTransactionTimeout(Xid xid, long timeout) throws DtxNotSelectedException, UnknownDtxBranchException, AndesException {
        QpidDistributedTransaction distributedTransaction = this.assertDtxTransaction();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Setting timeout" + timeout + "for the distributed transaction with GID : " + Arrays.toString(xid.getGlobalTransactionId())));
        }
        distributedTransaction.setTimeout(xid, timeout);
    }

    public ArrayList<Xid> recoverDtxTransactions() throws DtxNotSelectedException {
        return Andes.getInstance().getPreparedDtxTransactions();
    }

    private QpidDistributedTransaction assertDtxTransaction() throws DtxNotSelectedException {
        if (this.isAttachedToADistributedTransaction()) {
            return (QpidDistributedTransaction)this._transaction;
        }
        throw new DtxNotSelectedException();
    }

    public LogActor getLogActor() {
        return this._actor;
    }

    public void block(AMQQueue queue) {
        if (this._blocking.compareAndSet(false, true)) {
            this._actor.message(this._logSubject, ChannelMessages.FLOW_ENFORCED(queue.getNameShortString().toString()));
            this.flow(false);
        }
    }

    public void blockChannel() {
        if (!this.isClosing() || this._blocking.compareAndSet(Boolean.FALSE, Boolean.TRUE)) {
            this.flow(false);
        }
    }

    public void unblock(AMQQueue queue) {
        if (this._blocking.compareAndSet(true, false)) {
            this._actor.message(this._logSubject, ChannelMessages.FLOW_REMOVED());
            this.flow(true);
        }
    }

    public void unblockChannel() {
        if (!this.isClosing() || this._blocking.compareAndSet(Boolean.TRUE, Boolean.FALSE)) {
            this.flow(true);
        }
    }

    private void flow(boolean flow) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)"Communicating the Server Side Flow Control Ack To The Client");
        }
        MethodRegistry methodRegistry = this._session.getMethodRegistry();
        ChannelFlowBody responseBody = methodRegistry.createChannelFlowBody(flow);
        this._session.writeFrame(responseBody.generateFrame(this._channelId));
    }

    public boolean getBlocking() {
        return this._blocking.get();
    }

    @Override
    public VirtualHost getVirtualHost() {
        return this.getProtocolSession().getVirtualHost();
    }

    @Override
    public ConfiguredObject getParent() {
        return this.getVirtualHost();
    }

    @Override
    public SessionConfigType getConfigType() {
        return SessionConfigType.getInstance();
    }

    @Override
    public int getChannel() {
        return this.getChannelId();
    }

    @Override
    public boolean isAttached() {
        return true;
    }

    @Override
    public long getDetachedLifespan() {
        return 0L;
    }

    @Override
    public ConnectionConfig getConnectionConfig() {
        return (AMQProtocolEngine)this.getProtocolSession();
    }

    @Override
    public Long getExpiryTime() {
        return null;
    }

    @Override
    public Long getMaxClientRate() {
        return null;
    }

    @Override
    public boolean isDurable() {
        return false;
    }

    @Override
    public UUID getId() {
        return this._id;
    }

    @Override
    public String getSessionName() {
        return this.getConnectionConfig().getAddress() + "/" + this.getChannelId();
    }

    @Override
    public long getCreateTime() {
        return this._createTime;
    }

    @Override
    public void mgmtClose() throws AMQException {
        this._session.mgmtCloseChannel(this._channelId);
    }

    @Override
    public void checkTransactionStatus(long openWarn, long openClose, long idleWarn, long idleClose) throws AMQException {
        if (this.inTransaction()) {
            long currentTime = System.currentTimeMillis();
            long openTime = currentTime - this._transaction.getTransactionStartTime();
            long idleTime = currentTime - this._txnUpdateTime.get();
            if (idleWarn > 0L && idleTime > idleWarn) {
                CurrentActor.get().message(this._logSubject, ChannelMessages.IDLE_TXN(idleTime));
                _logger.warn((Object)("IDLE TRANSACTION ALERT " + this._logSubject.toString() + " " + idleTime + " ms"));
            } else if (openWarn > 0L && openTime > openWarn) {
                CurrentActor.get().message(this._logSubject, ChannelMessages.OPEN_TXN(openTime));
                _logger.warn((Object)("OPEN TRANSACTION ALERT " + this._logSubject.toString() + " " + openTime + " ms"));
            }
            if (idleClose > 0L && idleTime > idleClose) {
                this.getConnectionModel().closeSession(this, AMQConstant.RESOURCE_ERROR, "Idle transaction timed out");
            } else if (openClose > 0L && openTime > openClose) {
                this.getConnectionModel().closeSession(this, AMQConstant.RESOURCE_ERROR, "Open transaction timed out");
            }
        }
    }

    public void forgetMessages4Channel() {
        while (this.isMessagesAcksProcessing) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public <T extends StorableMessageMetaData> StoredMessage<T> addAMQPMessage(T metaData) {
        long mid = 0L;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("MessageID generated:" + mid));
        }
        return new StoredAMQPMessage(mid, metaData);
    }

    public void setLastRejectedMessageId(long lastRejectedMessageId) {
        this.lastRejectedMessageId = lastRejectedMessageId;
    }

    public void setLastRollbackedMessageId() {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("set LastRollbackedMessageId to : " + this.lastRejectedMessageId));
        }
        this.lastRollbackedMessageId = this.lastRejectedMessageId;
    }

    public void resetLastRollbackedMessageId() {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)"reset LastRollbackedMessageId to -1");
        }
        this.lastRollbackedMessageId = -1L;
    }

    public boolean isMessageBeyondLastRollback(long messageId) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("check if message is beyond last rollback. Last rollback id " + this.lastRollbackedMessageId + " current message id " + messageId));
        }
        if (this.lastRollbackedMessageId < 0L) {
            return false;
        }
        return messageId > this.lastRollbackedMessageId;
    }

    private class WriteReturnAction
    implements ServerTransaction.Action {
        private final AMQConstant _errorCode;
        private final IncomingMessage _message;
        private final String _description;

        public WriteReturnAction(AMQConstant errorCode, String description, IncomingMessage message) {
            this._errorCode = errorCode;
            this._message = message;
            this._description = description;
        }

        @Override
        public void postCommit() {
            try {
                AMQChannel.this._session.getProtocolOutputConverter().writeReturn(this._message.getMessagePublishInfo(), this._message.getContentHeader(), this._message, AMQChannel.this._channelId, this._errorCode.getCode(), new AMQShortString(this._description));
            }
            catch (AMQException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void onRollback() {
        }
    }

    private class MessageAcknowledgeAction
    implements ServerTransaction.Action {
        private final Collection<QueueEntry> _ackedMessages;

        public MessageAcknowledgeAction(Collection<QueueEntry> ackedMessages) {
            this._ackedMessages = ackedMessages;
        }

        @Override
        public void postCommit() {
            try {
                for (QueueEntry entry : this._ackedMessages) {
                    entry.discard();
                }
            }
            finally {
                AMQChannel.this._acknowledgedMessages.clear();
            }
        }

        @Override
        public void onRollback() {
            if (AMQChannel.this._rollingBack) {
                AMQChannel.this._resendList.addAll(this._ackedMessages);
            } else {
                try {
                    for (QueueEntry entry : this._ackedMessages) {
                        entry.release();
                    }
                }
                finally {
                    AMQChannel.this._acknowledgedMessages.clear();
                }
            }
        }
    }

    private class MessageDeliveryAction
    implements ServerTransaction.Action {
        private IncomingMessage _incommingMessage;
        private ArrayList<? extends BaseQueue> _destinationQueues;

        public MessageDeliveryAction(IncomingMessage currentMessage, ArrayList<? extends BaseQueue> destinationQueues, boolean transactional) {
            this._incommingMessage = currentMessage;
            this._destinationQueues = destinationQueues;
        }

        @Override
        public void postCommit() {
            try {
                boolean immediate = this._incommingMessage.isImmediate();
                AMQMessage amqMessage = AMQChannel.this.createAMQMessage(this._incommingMessage);
                MessageReference ref = amqMessage.newReference();
                for (BaseQueue baseQueue : this._destinationQueues) {
                    ImmediateAction action = immediate ? new ImmediateAction(baseQueue) : null;
                    baseQueue.enqueue(amqMessage, action);
                    if (!(baseQueue instanceof AMQQueue)) continue;
                    ((AMQQueue)baseQueue).checkCapacity(AMQChannel.this);
                }
                ref.release();
            }
            catch (AMQException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void onRollback() {
        }

        private class ImmediateAction
        implements BaseQueue.PostEnqueueAction {
            private final BaseQueue _queue;

            public ImmediateAction(BaseQueue queue) {
                this._queue = queue;
            }

            @Override
            public void onEnqueue(QueueEntry entry) {
                if (!entry.getDeliveredToConsumer() && entry.acquire()) {
                    LocalTransaction txn = new LocalTransaction(AMQChannel.this._messageStore);
                    ArrayList<QueueEntry> entries = new ArrayList<QueueEntry>(1);
                    entries.add(entry);
                    final AMQMessage message = (AMQMessage)entry.getMessage();
                    txn.dequeue(this._queue, entry.getMessage(), (ServerTransaction.Action)new MessageAcknowledgeAction(entries){

                        @Override
                        public void postCommit() {
                            try {
                                ProtocolOutputConverter outputConverter = AMQChannel.this._session.getProtocolOutputConverter();
                                outputConverter.writeReturn(message.getMessagePublishInfo(), message.getContentHeaderBody(), message, AMQChannel.this._channelId, AMQConstant.NO_CONSUMERS.getCode(), IMMEDIATE_DELIVERY_REPLY_TEXT);
                            }
                            catch (AMQException e) {
                                throw new RuntimeException(e);
                            }
                            super.postCommit();
                        }
                    });
                    txn.commit();
                }
            }
        }
    }
}

