/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.wso2.andes.AMQException;
import org.wso2.andes.amqp.AMQPUtils;
import org.wso2.andes.amqp.QpidAndesBridge;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.kernel.Andes;
import org.wso2.andes.management.common.mbeans.ManagedBroker;
import org.wso2.andes.management.common.mbeans.ManagedQueue;
import org.wso2.andes.management.common.mbeans.annotations.MBeanConstructor;
import org.wso2.andes.management.common.mbeans.annotations.MBeanDescription;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.exchange.ExchangeFactory;
import org.wso2.andes.server.exchange.ExchangeRegistry;
import org.wso2.andes.server.exchange.ExchangeType;
import org.wso2.andes.server.logging.LogMessage;
import org.wso2.andes.server.logging.actors.CurrentActor;
import org.wso2.andes.server.logging.actors.ManagementActor;
import org.wso2.andes.server.management.AMQManagedObject;
import org.wso2.andes.server.management.ManagedObject;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.AMQQueueFactory;
import org.wso2.andes.server.queue.AMQQueueMBean;
import org.wso2.andes.server.queue.QueueRegistry;
import org.wso2.andes.server.store.DurableConfigurationStore;
import org.wso2.andes.server.virtualhost.VirtualHost;
import org.wso2.andes.server.virtualhost.VirtualHostImpl;

@MBeanDescription(value="This MBean exposes the broker level management features")
public class AMQBrokerManagerMBean
extends AMQManagedObject
implements ManagedBroker {
    private final QueueRegistry _queueRegistry;
    private final ExchangeRegistry _exchangeRegistry;
    private final ExchangeFactory _exchangeFactory;
    private final DurableConfigurationStore _durableConfig;
    private final VirtualHostImpl.VirtualHostMBean _virtualHostMBean;

    @MBeanConstructor(value="Creates the Broker Manager MBean")
    public AMQBrokerManagerMBean(VirtualHostImpl.VirtualHostMBean virtualHostMBean) throws JMException {
        super(ManagedBroker.class, "VirtualHostManager");
        this._virtualHostMBean = virtualHostMBean;
        VirtualHostImpl virtualHost = virtualHostMBean.getVirtualHost();
        this._queueRegistry = virtualHost.getQueueRegistry();
        this._exchangeRegistry = virtualHost.getExchangeRegistry();
        this._durableConfig = virtualHost.getDurableConfigurationStore();
        this._exchangeFactory = virtualHost.getExchangeFactory();
    }

    @Override
    public String getObjectInstanceName() {
        return this._virtualHostMBean.getVirtualHost().getName();
    }

    @Override
    public String[] getExchangeTypes() throws IOException {
        ArrayList<String> exchangeTypes = new ArrayList<String>();
        for (ExchangeType<? extends Exchange> ex : this._exchangeFactory.getPublicCreatableTypes()) {
            exchangeTypes.add(ex.getName().toString());
        }
        return exchangeTypes.toArray(new String[exchangeTypes.size()]);
    }

    @Override
    public List<String> retrieveQueueAttributeNames() throws IOException {
        return ManagedQueue.QUEUE_ATTRIBUTES;
    }

    @Override
    public List<List<Object>> retrieveQueueAttributeValues(String[] attributes) throws IOException {
        if (this._queueRegistry.getQueues().size() == 0) {
            return new ArrayList<List<Object>>();
        }
        ArrayList<List<Object>> queueAttributesList = new ArrayList<List<Object>>(this._queueRegistry.getQueues().size());
        int attributesLength = attributes.length;
        for (AMQQueue queue : this._queueRegistry.getQueues()) {
            AMQQueueMBean mbean = (AMQQueueMBean)queue.getManagedObject();
            if (mbean == null) continue;
            ArrayList<Object> attributeValues = new ArrayList<Object>(attributesLength);
            for (String attribute : attributes) {
                try {
                    attributeValues.add(mbean.getAttribute(attribute));
                }
                catch (Exception e) {
                    attributeValues.add("-");
                }
            }
            queueAttributesList.add(attributeValues);
        }
        return queueAttributesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createNewExchange(String exchangeName, String type, boolean durable) throws JMException {
        CurrentActor.set(new ManagementActor(this._logActor.getRootMessageLogger()));
        try {
            ExchangeRegistry exchangeRegistry = this._exchangeRegistry;
            synchronized (exchangeRegistry) {
                Exchange exchange = this._exchangeRegistry.getExchange(new AMQShortString(exchangeName));
                if (exchange == null) {
                    exchange = this._exchangeFactory.createExchange(new AMQShortString(exchangeName), new AMQShortString(type), durable, false, 0);
                    this._exchangeRegistry.registerExchange(exchange);
                    if (durable) {
                        this._durableConfig.createExchange(exchange);
                        QpidAndesBridge.createExchange(exchange);
                    }
                } else {
                    throw new JMException("The exchange \"" + exchangeName + "\" already exists.");
                }
            }
        }
        catch (AMQException ex) {
            JMException jme = new JMException(ex.toString());
            throw new MBeanException(jme, "Error in creating exchange " + exchangeName);
        }
        finally {
            CurrentActor.remove();
        }
    }

    @Override
    public void unregisterExchange(String exchangeName) throws JMException {
        CurrentActor.set(new ManagementActor(this._logActor.getRootMessageLogger()));
        try {
            this._exchangeRegistry.unregisterExchange(new AMQShortString(exchangeName), false);
        }
        catch (AMQException ex) {
            JMException jme = new JMException(ex.toString());
            throw new MBeanException(jme, "Error in unregistering exchange " + exchangeName);
        }
        finally {
            CurrentActor.remove();
        }
    }

    @Override
    public void createNewQueue(String queueName, String owner, boolean durable) throws JMException {
        AMQQueue queue = this._queueRegistry.getQueue(new AMQShortString(queueName));
        try {
            if (queue != null) {
                throw new JMException("The queue \"" + queueName + "\" already exists.");
            }
            CurrentActor.set(new ManagementActor(this._logActor.getRootMessageLogger()));
            AMQShortString ownerShortString = null;
            if (owner != null) {
                ownerShortString = new AMQShortString(owner);
            }
            if ((queue = AMQQueueFactory.createAMQQueueImpl(new AMQShortString(queueName), durable, ownerShortString, false, false, this.getVirtualHost(), null)).isDurable() && !queue.isAutoDelete()) {
                this._durableConfig.createQueue(queue);
            }
            QpidAndesBridge.createQueue(queue);
        }
        catch (Exception ex) {
            JMException jme = new JMException(ex.toString());
            throw new MBeanException(jme, "The queue \"" + queueName + "\" already exists.");
        }
        finally {
            CurrentActor.remove();
        }
    }

    private VirtualHost getVirtualHost() {
        return this._virtualHostMBean.getVirtualHost();
    }

    @Override
    public void deleteQueue(final String queueName) throws JMException {
        block11: {
            AMQQueue queue = this._queueRegistry.getQueue(new AMQShortString(queueName));
            if (queue == null) {
                throw new JMException("The Queue " + queueName + " is not a registered queue.");
            }
            try {
                CurrentActor.set(new ManagementActor(this._logActor.getRootMessageLogger()));
                boolean isQueueDeletable = Andes.getInstance().checkIfQueueDeletable(AMQPUtils.createInboundQueueEvent(queue));
                if (isQueueDeletable) {
                    queue.delete();
                    if (queue.isDurable()) {
                        this._durableConfig.removeQueue(queue);
                    }
                    QpidAndesBridge.deleteQueue(queue);
                    break block11;
                }
                this._logActor.message(new LogMessage(){
                    String message;
                    {
                        this.message = "Cannot Delete Queue" + queueName + " It Has Registered Subscriptions.";
                    }

                    public String toString() {
                        return this.message;
                    }

                    @Override
                    public String getLogHierarchy() {
                        return "amqp.queue";
                    }
                });
                throw new AMQException("Cannot Delete Queue" + queueName + " It Has Registered Subscriptions.");
            }
            catch (AMQException ex) {
                JMException jme = new JMException(ex.toString());
                if (ex.toString().contains("not a registered queue")) {
                    throw new MBeanException(jme, "The Queue " + queueName + " is not a registered queue.");
                }
                if (ex.toString().contains("Has Registered Subscriptions")) {
                    throw new MBeanException(jme, "Queue " + queueName + " has active subscribers. Please stop them first.");
                }
                throw new MBeanException(jme, "Error in deleting queue " + queueName + ":");
            }
            catch (Exception e) {
                throw new MBeanException(e, "Error in deleting queue " + queueName + ". There was an issue with cluster coordination");
            }
            finally {
                CurrentActor.remove();
            }
        }
    }

    @Override
    public ManagedObject getParentObject() {
        return this._virtualHostMBean;
    }

    @Override
    public ObjectName getObjectName() throws MalformedObjectNameException {
        return this.getObjectNameForSingleInstanceMBean();
    }

    @Override
    public void resetStatistics() {
        this.getVirtualHost().resetStatistics();
    }

    @Override
    public double getPeakMessageDeliveryRate() {
        return this.getVirtualHost().getMessageDeliveryStatistics().getPeak();
    }

    @Override
    public double getPeakDataDeliveryRate() {
        return this.getVirtualHost().getDataDeliveryStatistics().getPeak();
    }

    @Override
    public double getMessageDeliveryRate() {
        return this.getVirtualHost().getMessageDeliveryStatistics().getRate();
    }

    @Override
    public double getDataDeliveryRate() {
        return this.getVirtualHost().getDataDeliveryStatistics().getRate();
    }

    @Override
    public long getTotalMessagesDelivered() {
        return this.getVirtualHost().getMessageDeliveryStatistics().getTotal();
    }

    @Override
    public long getTotalDataDelivered() {
        return this.getVirtualHost().getDataDeliveryStatistics().getTotal();
    }

    @Override
    public double getPeakMessageReceiptRate() {
        return this.getVirtualHost().getMessageReceiptStatistics().getPeak();
    }

    @Override
    public double getPeakDataReceiptRate() {
        return this.getVirtualHost().getDataReceiptStatistics().getPeak();
    }

    @Override
    public double getMessageReceiptRate() {
        return this.getVirtualHost().getMessageReceiptStatistics().getRate();
    }

    @Override
    public double getDataReceiptRate() {
        return this.getVirtualHost().getDataReceiptStatistics().getRate();
    }

    @Override
    public long getTotalMessagesReceived() {
        return this.getVirtualHost().getMessageReceiptStatistics().getTotal();
    }

    @Override
    public long getTotalDataReceived() {
        return this.getVirtualHost().getDataReceiptStatistics().getTotal();
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.getVirtualHost().isStatisticsEnabled();
    }
}

